<?php namespace Visiosoft\SimpleClassifiedModule\MatchedCategory\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\Form\MatchCategoryFormHandler;

class MatchCategoryFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'category_oc' => [
            'type' => 'anomaly.field_type.text',
            'hidden' => true,
        ],
        'category_trendyol' => [
            'type' => 'anomaly.field_type.text'
        ],   
        'category_n11' => [
            'type' => 'anomaly.field_type.text'
        ],   
        'category_hepsiburada' => [
            'type' => 'anomaly.field_type.text'
        ],   
        'category_gittigidiyor' => [
            'type' => 'anomaly.field_type.text'
        ],
        'matched_variants' => [
            'type' => 'visiosoft.field_type.json',
            'hidden' => true,
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'match' => [
            'text' => 'visiosoft.module.simple_classified::button.match.name',
            'redirect' => '/admin/simple_classified',
        ]
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'form_view' => 'visiosoft.module.simple_classified::admin/categories/matchCategory'
    ];

    protected $handler = MatchCategoryFormHandler::class;

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'styles.css' => [
            'visiosoft.module.simple_classified::css/main.css'
        ],        
    ];

}
