<?php namespace Visiosoft\SimpleClassifiedModule\Http\Controller\Admin;

use Visiosoft\SimpleClassifiedModule\CategoryTemplate\Form\CategoryTemplateFormBuilder;
use Visiosoft\SimpleClassifiedModule\CategoryTemplate\Table\CustomCategoryTemplateTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class CategoryTemplatesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param CategoryTemplateTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CustomCategoryTemplateTableBuilder $table)
    {
        return $table->render();
    }

    public function select()
    {
        return $this->view->make(
            'visiosoft.module.simple_classified::admin/categoryTemplates/selectCategory'       
        );
    }


    public function create(CategoryTemplateFormBuilder $form)
    {
       $checkedCategoryIds = $_POST['categories'];
        return $this->view->make('visiosoft.module.simple_classified::admin/categoryTemplates/createTemplate', compact('checkedCategoryIds'));
    }

    /**
     * Edit an existing entry.
     *
     * @param CategoryTemplateFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CategoryTemplateFormBuilder $form, $id)
    {
        return $this->view->make('visiosoft.module.simple_classified::admin/categoryTemplates/editTemplate', compact('id'));
    }
}
