<?php namespace Visiosoft\SimpleClassifiedModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SimpleClassifiedModule\MatchedCategory\MatchedCategoryRepository;
use Visiosoft\SimpleClassifiedModule\CategoryTemplate\CategoryTemplateRepository;
use Visiosoft\AdvsModule\Productoption\ProductoptionRepository;
use Visiosoft\AdvsModule\ProductoptionsValue\ProductoptionsValueRepository;
use Anomaly\Streams\Platform\Message\MessageBag;

class AjaxController extends AdminController
{
    public function returnMatchedCategoriesAndTemplates($market_names, $categoryIds, MessageBag $messages)
    {
        $arrayToBeReturned = array();

        $market_namesArr = explode(',', $market_names);
        $categoryIdsArr = explode(',', $categoryIds);

        // Let's add the ids of the matched categories to the array we will return.

        $matchedCategories = app(MatchedCategoryRepository::class);
        $relevantCategory = $matchedCategories->findBy('oc_categoryId', end($categoryIdsArr));

        if (is_null($relevantCategory)) {
            $messages->error('Please first match the category you selected with relevant marketplace category');
            return;
        }

        $categoryTemplates = app(CategoryTemplateRepository::class);
        $categoryIdsArr_startFromTheMostSubCat = array_reverse($categoryIdsArr);

        $allCategoryTemplates = $categoryTemplates->all();
        $templateToBeReturned;

        for ($x = 0; $x < count( $categoryIdsArr_startFromTheMostSubCat ); $x++ ) {

            foreach($allCategoryTemplates as $categoryTemplate) {
                $attributes = json_decode($categoryTemplate->oc_categoryIds);

                if (in_array($categoryIdsArr_startFromTheMostSubCat[$x], $attributes)) {
                    $templateToBeReturned = $categoryTemplate;
                    break 2;
                }
            }
        }

        if (is_null($templateToBeReturned)) {
            $messages->error('Please first assign a template to your selected category for the relevant marketplace');
            return;
        }
        
        foreach ($market_namesArr as $market_name) {
            $arrayToBeReturned[$market_name . '_categoryId'] = $relevantCategory[$market_name . '_categoryId'];
            $arrayToBeReturned[$market_name . '_categoryName'] = $relevantCategory[$market_name . '_categoryName'];
            $arrayToBeReturned[$market_name . '_packageAttributes'] = $templateToBeReturned[$market_name . '_packageAttributes'];
        }

        return json_encode($arrayToBeReturned);
        
        /*
            [
                'trendyol_categoryId' => '766',
                'n11_categoryId' => '991',
                'trendyol_packageAttributes' => json
                'n11_packageAttributes' => json
            ]
        */
    }   

    public function returnVariations($categoryId) {
        $categoryVariationsAndVariants = array();

        $allVariations = app(ProductoptionRepository::class);
        $categoryVariations = $allVariations->findAllBy('category', $categoryId);

        foreach ($categoryVariations as $variation) {
            $variation['id'] = $variation->id;
            $variation['name'] = $variation->name;

            $variants = array();
            $allVariants = app(ProductoptionsValueRepository::class);
            $variationVariants = $allVariants->findAllBy('product_option_id', $variation->id);
            foreach ($variationVariants as $variant) {
                array_push($variants, [
                    'id' => $variant->id,
                    'name' => $variant->name,
                ]);
            }
            $variation['variants'] = $variants;
            array_push($categoryVariationsAndVariants, $variation);
        }

        return json_encode($categoryVariationsAndVariants);
    }
}