$(document).ready(function(){
    let categoryInputField = $("#category_trendyol");
    let subCategories = [];
    let currentUrl = window.location.href;
    let specifiedAttributes;
    let specifiedAttributesObject = {};

    if (currentUrl.includes('edit/trendyol')) {
        categoryInputField.after(
            `<button type="button" class="btn btn-danger" id="edit_categoryAttributes">Edit Category Attributes</button>`
        );     
        specifiedAttributes = JSON.parse(document.getElementsByName('categoryAttributes')[0].value);
        for (let specifiedAttribute of specifiedAttributes) {
            if (specifiedAttribute.customAttributeValue) {
                specifiedAttributesObject[specifiedAttribute.attributeId] = specifiedAttribute.customAttributeValue;
            } else {
                specifiedAttributesObject[specifiedAttribute.attributeId] = specifiedAttribute.attributeValueId;
            }
        }

        document.getElementById('edit_categoryAttributes').onclick = function() {
            getCategoryAttributes(Number(document.getElementById('category_trendyol').value.match(/([^-]+)/)[0]));
        }
    }

    categoryInputField.after(
        `<div class="list-group" id="matched_categories"></div>`
    );

    categoryInputField.keyup(function() {
        if (categoryInputField.val().length < 2) {
            $("div#matched_categories").html(""); 
            $("div#matched_categories").hide();
            return;
        }
        $("div#matched_categories").show();
        let currentInput = categoryInputField.val();
        var options = {
            pre: '<', 
            post: '>', 
            extract: function(el) { return el.name; }
        };
        let results = fuzzy.filter(currentInput, subCategories, options);
        let matches = results.map(function(el) { return el.original; });

        extraFilteredMatches = matches.filter(function(item, index, array) {            
            $result = item.name.toLowerCase().indexOf(`${categoryInputField.val().toLowerCase()}`);
            if ($result === -1) {
                return false;
            } else {
                return true;
            }
        });

        $("div#matched_categories").html("");    
        extraFilteredMatches.forEach(function(item, index, array) {
            $("#matched_categories").append(`
                <a href="#" id="${item.id}" class="list-group-item list-group-item-action category-option">${item.name}</a>
            `);
        });
    });

    $("#category_trendyol").blur(function(event) {
        if (!($(event.relatedTarget).attr('class') == "list-group-item list-group-item-action category-option")) {
            $("div#matched_categories").hide();
        }
    });

    $("#category_trendyol").focus(function() {
        if (categoryInputField.val().length >= 2) {
            $("div#matched_categories").show();
        }
    });

    $("div#matched_categories").on("click", "a", function(event) {
        event.preventDefault();
        categoryInputField.val($(this).attr('id') + ' - ' + $(this).text());
        $("div#matched_categories").html("");
        $("div#matched_categories").hide();
        get_trendyol_CategoryAttributes($(this).attr('id'));
    });

    $("#matched_categories").after(
        `<div class="lds-ellipsis" id="categoryAttributes_loading"><div></div><div></div><div></div><div></div></div>`
    );

    function getCategoryAttributes(categoryId) {
        $("#categoryAttributes_loading").show();
        $.ajax({
            url: `/admin/getProductInformation/categoryAttributes/${categoryId}`,
            dataType: "json",
            success: function(categoryAttributes) {
                $("#categoryAttributes_loading").hide();
            }
        });
    }

    function getCategories() {
        $.ajax({
            url: `/admin/getProductInformation/categories`,
            dataType: "json",
            success: function(categories) {
                getSubCategories(categories.categories);
            }
        });
    }
    
    getCategories();

    function getSubCategories(categories) {
        for (let category of categories) {
            if (category.subCategories.length === 0) {
                subCategories.push({
                    name: category.name,
                    id: category.id
                });
            } else {
                getSubCategories(category.subCategories);
            }
        }
    }
});


