<?php namespace Visiosoft\ShippingModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CartsModule\Cart\Event\AddedItemInCart;
use Visiosoft\ShippingModule\Shipping\Contract\ShippingRepositoryInterface;
use Visiosoft\ShippingModule\Shipping\Listeners\CalculateItemInCart;
use Visiosoft\ShippingModule\Shipping\ShippingAdvsForm\ShippingAdvsFormBuilder;
use Visiosoft\ShippingModule\Shipping\ShippingRepository;
use Anomaly\Streams\Platform\Model\Shipping\ShippingShippingEntryModel;
use Visiosoft\ShippingModule\Shipping\ShippingModel;
use Visiosoft\ShippingModule\Company\Contract\CompanyRepositoryInterface;
use Visiosoft\ShippingModule\Company\CompanyRepository;
use Anomaly\Streams\Platform\Model\Shipping\ShippingCompanyEntryModel;
use Visiosoft\ShippingModule\Company\CompanyModel;
use Illuminate\Routing\Router;

class ShippingModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        ShippingModulePlugin::class
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/shipping' => 'Visiosoft\ShippingModule\Http\Controller\Admin\ShippingController@index',
        'admin/shipping/create' => 'Visiosoft\ShippingModule\Http\Controller\Admin\ShippingController@create',
        'admin/shipping/edit/{id}' => 'Visiosoft\ShippingModule\Http\Controller\Admin\ShippingController@edit',
        'admin/shipping/company' => 'Visiosoft\ShippingModule\Http\Controller\Admin\CompanyController@index',
        'admin/shipping/company/create' => 'Visiosoft\ShippingModule\Http\Controller\Admin\CompanyController@create',
        'admin/shipping/company/edit/{id}' => 'Visiosoft\ShippingModule\Http\Controller\Admin\CompanyController@edit',

        'advs/shipping/{id}' => [
            'as' => 'visiosoft.module.shipping::create_shipping',
            'uses' => 'Visiosoft\ShippingModule\Http\Controller\ShippingController@create',
        ],

        'ajax/shipping-item' => [
            'as' => 'visiosoft.module.shipping::ajax.shipping_item',
            'uses' => 'Visiosoft\ShippingModule\Http\Controller\ShippingController@shippingItem',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\ShippingModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\ShippingModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        AddedItemInCart::class => [
            CalculateItemInCart::class
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\ShippingModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        ShippingShippingEntryModel::class => ShippingModel::class,
        ShippingCompanyEntryModel::class => CompanyModel::class,
        'shipping_advs_form' => ShippingAdvsFormBuilder::class,

    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ShippingRepositoryInterface::class => ShippingRepository::class,
        CompanyRepositoryInterface::class => CompanyRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
