<?php namespace Visiosoft\ShippingModule\Shipping\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class ShippingTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'country',
        'company',
        'is_free',
        'one_item_price' => [
          'value' => '{{ (entry.is_free) ? "-" : currency_format(entry.one_item_price,setting_value(\'streams::currency\')) }}'
        ],
        'additional_item_price'=> [
            'value' => '{{ (entry.is_free) ? "-" : currency_format(entry.additional_item_price,setting_value(\'streams::currency\')) }}'
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
