<?php namespace Visiosoft\ShippingModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\ShippingModule\Shipping\Command\getShippingAmount;

class ShippingModulePlugin extends Plugin
{

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getShippingAmount',
                function ($ad_id) {
                    return $this->dispatch(new getShippingAmount($ad_id));
                }
            )
        ];
    }
}
