<?php namespace Visiosoft\ShippingModule\Shipping\Command;

use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\LocationModule\Country\Contract\CountryRepositoryInterface;
use Visiosoft\ShippingModule\Shipping\Contract\ShippingRepositoryInterface;

class getShippingAmount
{
    protected $ad_id;

    public function __construct($ad_id)
    {
        $this->ad_id = $ad_id;
    }

    public function handle(ShippingRepositoryInterface $shippingRepository, CountryRepositoryInterface $countryRepository)
    {
        $currency = setting_value('streams::currency');

        if ($shipping_entries = $shippingRepository->findAllBy('adv_id', $this->ad_id)) {

            $country_code = "TR";

            // My Location
            try {
                $ip = request()->ip();
                $location = file_get_contents("https://ipinfo.io/" . $ip . "/json");
                $location = json_decode($location, true);
                $country_code = $location['country'];
            } catch (\Exception $exception) {
                abort(403, $exception->getMessage());
            }

            $country = $countryRepository->findBy('abv', $country_code);

            if ($country) {
                // Shipping By Country
                $country_shipping = $shipping_entries->filter(
                    function ($shipping_entry) use ($country) {
                        return $shipping_entry->country_id == $country->id;
                    }
                );
            }

            // Shipping By Other
            $everywhere_shipping = $shipping_entries->filter(
                function ($shipping_entry) {
                    return $shipping_entry->country_id == 0;
                }
            );

            $shipping = null;

            if ($country and count($country_shipping)) {
                $shipping = $country_shipping->first();
            } elseif (count($everywhere_shipping)) {
                $shipping = $everywhere_shipping->first();
            }

            if ($shipping) {
                return app(Currency::class)->format($shipping->one_item_price, $currency);
            }
        }

        return app(Currency::class)->format(setting_value('visiosoft.module.orders::shipping'), $currency);
    }
}
