<?php namespace Visiosoft\ShippingModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\ShippingModule\Company\Contract\CompanyRepositoryInterface;

class ShippingModuleSeeder extends Seeder
{
    public function run(CompanyRepositoryInterface $companyRepository)
    {
        $shipping_companies = [
            'UPS Kargo',
            'Sürat Kargo',
            'MNG Kargo',
            'Yurtiçi Kargo',
            'Aras Kargo',
        ];
        foreach ($shipping_companies as $company) {
            $companyRepository->create([
                'en' => [
                    'name' => $company
                ]
            ]);
        }
    }
}