<?php namespace Visiosoft\ShippingModule\Shipping\ShippingAdvsForm;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\ShippingModule\Shipping\Contract\ShippingRepositoryInterface;

class ShippingAdvsFormHandler
{
    public function handle(ShippingAdvsFormBuilder $builder, ShippingRepositoryInterface $repository, MessageBag $message)
    {
        if (!$builder->canSave()) {
            return;
        }

        //Delete old record
        $repository->newQuery()
            ->where('adv_id',$builder->getFormEntry())
            ->delete();

        $shippings = array();
        for ($i = 1; $i <= 10; $i++) {
            if (request()->has('company-' . $i)) {
                $shippings[request()->get('country-' . $i)] = [
                    'country' => request()->get('country-' . $i),
                    'company' => request()->get('company-' . $i),
                    'is_free' => request()->get('is_free-' . $i),
                    'one_item_price' => request()->get('one_item_price-' . $i),
                    'additional_item_price' => request()->get('additional_item_price-' . $i),
                ];
            }
        }

        foreach ($shippings as $item) {
            $repository->create([
                'adv' => $builder->getFormEntry(),
                'country' => $item['country'],
                'company' => $item['company'],
                'is_free' => $item['is_free'],
                'one_item_price' => $item['one_item_price'],
                'additional_item_price' => $item['additional_item_price']
            ]);
        }
    }
}
