<?php namespace Visiosoft\ShippingModule\Shipping\Listeners;

use Visiosoft\CartsModule\Cart\Contract\CartRepositoryInterface;
use Visiosoft\CartsModule\Cart\Event\AddedItemInCart;
use Visiosoft\LocationModule\Country\Contract\CountryRepositoryInterface;
use Visiosoft\ShippingModule\Shipping\Contract\ShippingRepositoryInterface;

class CalculateItemInCart
{
    protected $shippingRepository;
    protected $countryRepository;
    protected $cartRepository;

    public function __construct(ShippingRepositoryInterface $shippingRepository,
                                CountryRepositoryInterface $countryRepository,
                                CartRepositoryInterface $cartRepository)
    {
        $this->shippingRepository = $shippingRepository;
        $this->countryRepository = $countryRepository;
        $this->cartRepository = $cartRepository;
    }

    public function handle(AddedItemInCart $event)
    {

        $country_code = "TR";
        // My Location
        try {
            $ip = request()->ip();

            $arrContextOptions = array(
                "ssl" => array(
                    "verify_peer" => false,
                    "verify_peer_name" => false,
                ),
            );
            $location = file_get_contents("https://ipinfo.io/" . $ip . "/json", false, stream_context_create($arrContextOptions));
            $location = json_decode($location, true);
            $country_code = $location['country'];
        } catch (\Exception $exception) {
            abort(403, $exception->getMessage());
        }

        $country = $this->countryRepository->findBy('abv', $country_code);

        $cart = $event->getCart();

        $cart_shipping = $cart->shipping;

        foreach ($cart->items as $item) {

            if ($item->entry_type === 'Visiosoft\AdvsModule\Adv\AdvModel') {

                $entry = $item->entry;

                $shipping_entries = $this->shippingRepository->findAllBy('adv_id', $item->entry_id);

                if ($entry and count($shipping_entries)) {

                    // If I have a location
                    if ($country) {
                        // Shipping By Country
                        $country_shipping = $shipping_entries->filter(
                            function ($shipping_entry) use ($entry, $country) {
                                return $shipping_entry->country_id == $country->id;
                            }
                        );
                    }

                    // Shipping By Other
                    $everywhere_shipping = $shipping_entries->filter(
                        function ($shipping_entry) {
                            return $shipping_entry->country_id == 0;
                        }
                    );

                    $shipping = null;

                    if ($country and count($country_shipping)) {
                        $shipping = $country_shipping->first();
                    } elseif (count($everywhere_shipping)) {
                        $shipping = $everywhere_shipping->first();
                    }

                    if ($shipping) {
                        $quantity = $item->quantity;
                        $one_item_price = ($shipping->one_item_price) ? $shipping->one_item_price : 0;
                        $additional_item_price = ($shipping->additional_item_price) ? $shipping->additional_item_price : 0;

                        // Calculate Shipping Price With Quantity
                        $shipping_price = ($quantity < 2) ? $one_item_price : $one_item_price + ($additional_item_price * ($quantity - 1));
                        $cart_shipping += $shipping_price;
                    }
                }
            }
        }

        if ($cart_shipping != $cart->shipping) {
            $cart->setAttribute('shipping',$cart_shipping);
            $cart->save();
        }
    }
}
