<?php namespace Visiosoft\ShippingModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\Command\IsOptionsByCategory;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\OptionConfiguration\Contract\OptionConfigurationRepositoryInterface;
use Visiosoft\LocationModule\Country\Contract\CountryRepositoryInterface;
use Visiosoft\ShippingModule\Company\Contract\CompanyRepositoryInterface;
use Visiosoft\ShippingModule\Shipping\Contract\ShippingRepositoryInterface;

class ShippingController extends PublicController
{
    protected $shippingRepository;
    protected $countryRepository;
    protected $advRepository;
    protected $companyRepository;

    public function __construct(
        ShippingRepositoryInterface $shippingRepository,
        CountryRepositoryInterface $countryRepository,
        AdvRepositoryInterface $advRepository,
        CompanyRepositoryInterface $companyRepository)
    {
        $this->shippingRepository = $shippingRepository;
        $this->countryRepository = $countryRepository;
        $this->advRepository = $advRepository;
        $this->companyRepository = $companyRepository;
        parent::__construct();
    }

    public function create($id)
    {
        $adv = $this->advRepository->find($id);

        $shipping_entries = $this->shippingRepository->findAllBy('adv_id', $id);

        if (is_null($adv)) {
            $this->messages->error(trans('visiosoft.module.advs::message.no_add_found'));
            return $this->redirect->to(route('advs::create_adv'));
        }

        if ($adv->created_by_id != auth()->id()
            && !auth()->user()->hasPermission('visiosoft.module.advs::advs.write')) {
            abort(403);
        }

        $default_shipping_countries = ($adv->country_id) ? [0, $adv->country_id] : [0];

        $default_shipping_entries = $shipping_entries->filter(
            function ($entry) use ($default_shipping_countries) {
                return (in_array($entry->country_id, $default_shipping_countries));
            }
        );

        $default_shipping = array();

        foreach ($default_shipping_entries as $entry)
        {
            $default_shipping[$entry->country_id] = $entry;
        }


        $other_shipping_entries = $shipping_entries->filter(
            function ($entry) use ($default_shipping_countries) {
                return (!in_array($entry->country_id, $default_shipping_countries));
            }
        );

        $countries = $this->countryRepository->newQuery()->get()->all();
        $companies = $this->companyRepository->newQuery()->get()->all();

        return $this->view->make('visiosoft.module.shipping::new-ad/create-shipping', compact('countries',
            'adv', 'companies', 'id', 'default_shipping', 'other_shipping_entries'));
    }

    public function shippingItem()
    {
        $countries = $this->countryRepository->newQuery()->get()->all();
        $companies = $this->companyRepository->newQuery()->get()->all();

        return $this->view->make('visiosoft.module.shipping::new-ad/partials/item', compact('countries',
            'companies'));
    }
}
