let actionShipping = {
    add: function () {
        if ($('.shipping-list-item').length < 11) {
            loading.show();

            let id = $('.shipping-list-item').length + 1;

            crudAjax('', '/ajax/shipping-item?id=' + id, 'GET', function (data) {
                $('.shipping-list').append(data);
            }, true).then(function () {
                refreshSelects();
                refreshDecimal();
                loading.hide();
            })
        }
    },
    delete: function (id) {
        $('.shipping-list-item[data-id="' + id + '"]').remove();
    },
};

function refreshSelects() {
    $('.select-bootstrap').selectpicker();
}

function isFree(id) {
    if ($('input[name="is_free-' + id + '"]').is(':checked')) {
        $('.shipping-list-item[data-id="' + id + '"]').find(".price-field").remove();
    } else {

        $('.shipping-list-item[data-id="' + id + '"]').find("div[data-input='one_item_price']").append(
            `
            <div class="form-group price-field">
                            <label class="label-input pl-1" for="one_item_price">
                                ${shipping_translate.one_item_price}
                                <span class="required text-danger">*</span>
                            </label>
                            <div class="input-wrapper">
                                <input step="any" value="0.00" min="1" type="number" data-provides="anomaly.field_type.decimal" class="form-control" data-decimals="2">
                            </div>
                        </div>
            `
        );

        $('.shipping-list-item[data-id="' + id + '"]').find("div[data-input='additional_item_price']").append(
            `
            <div class="form-group price-field">
                            <label class="label-input pl-1" for="additional_item_price">
                                ${shipping_translate.additional_item_price}
                                <span class="required text-danger">*</span>
                            </label>
                            <div class="input-wrapper">
                                <input step="any" value="0.00" min="1" type="number" data-provides="anomaly.field_type.decimal" class="form-control" data-decimals="2">
                            </div>
                        </div>
            `
        );

        refreshDecimal()
    }
}


function refreshDecimal() {
    (function (window, document) {

        let fields = Array.prototype.slice.call(
            document.querySelectorAll('input[data-provides="anomaly.field_type.decimal"]')
        );

        fields.forEach(function (field) {

            field.addEventListener('change', function (event) {

                if (event.target.value == '') {
                    return;
                }

                event.target.value = Number(event.target.value).toFixed(event.target.dataset.decimals);
            });
        });
    })(window, document);

}

const loading = {
    show() {
        this.loader.show();
    },
    hide() {
        this.loader.hide();
    },
    loader: $('.loading'),
}

$('.shipping-area').on('change','input[type="number"]', function () {
    let element = $(this);

    if (element.val() == "") {
        element.val("0.00");
    }
});
