<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSeoCreateLegendsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'legends',
        'title_column' => 'id',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        "category" => [
            'required' => true,
            'unique' => true
        ],
        'advs_title' => [
            'translatable' => true
        ],
        'advs_description' => [
            'translatable' => true
        ],
        'category_title' => [
            'translatable' => true
        ],
        'category_description' => [
            'translatable' => true
        ],
    ];

}
