<?php namespace Visiosoft\SeoModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Seo\SeoLegendsEntryModel;
use Visiosoft\SeoModule\Legend\Contract\LegendRepositoryInterface;
use Visiosoft\SeoModule\Legend\LegendModel;
use Visiosoft\SeoModule\Legend\LegendRepository;

class SeoModuleServiceProvider extends AddonServiceProvider
{
    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/seo'           => 'Visiosoft\SeoModule\Http\Controller\Admin\LegendsController@index',
        'admin/seo/create'    => 'Visiosoft\SeoModule\Http\Controller\Admin\LegendsController@create',
        'admin/seo/edit/{id}' => 'Visiosoft\SeoModule\Http\Controller\Admin\LegendsController@edit',
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        SeoLegendsEntryModel::class => LegendModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        LegendRepositoryInterface::class => LegendRepository::class,
    ];
}
