<?php namespace Visiosoft\SeoModule\Legend;

use Visiosoft\SeoModule\Legend\Contract\LegendRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class LegendRepository extends EntryRepository implements LegendRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var LegendModel
     */
    protected $model;

    /**
     * Create a new LegendRepository instance.
     *
     * @param LegendModel $model
     */
    public function __construct(LegendModel $model)
    {
        $this->model = $model;
    }

    public function findByCategoryID($catID)
    {
        return $this->findBy('category_id', $catID);
    }
}
