<?php namespace Visiosoft\SeoModule\Legend\Command;

use Illuminate\Support\Str;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\SeoModule\Legend\Contract\LegendRepositoryInterface;

class AddMetaData
{
    protected $categoryID;
    protected $type;
    protected $adID;

    public function __construct($categoryID, $type, $adID = null)
    {
        $this->categoryID = $categoryID;
        $this->type = $type;
        $this->adID = $adID;
    }

    /*
     *
     * > {{current_catname}}
     * > {{previous_catname}}
     * > {{cat1_name}}
     * > {{cat2_name}}
     * > {{cat3_name}}
     * > ..
     * > {{city_name}}
     * > {{district_name}}
     * > {{neighborhood_name}}
     * > {{village_name}}
     * >  ...
     * > {{cf1_name}} (Example: Fuel)
     * > {{cf1_value}}   (Example: Gas)
     * > {{cf2_name}} (Example: Doors)
     * > {{cf2_value}}   (Example: 4)
     *
     */
    public function handle(
        LegendRepositoryInterface $legendRepository,
        CategoryRepositoryInterface $categoryRepository,
        AdvRepositoryInterface $advRepository
    )
    {
        if ($legend = $legendRepository->findByCategoryID($this->categoryID)) {
            if ($this->type === 'category') {
                $metas = [
                    'metaTitle' => $legend->category_title,
                    'metaDesc' => $legend->category_description,
                ];

                foreach ($metas as $type => $meta) {
                    if (Str::contains($metas[$type], ['{{current_catname}}'])) {
                        $currentCat = $categoryRepository->find($this->categoryID);
                        $metas[$type] = str_replace('{{current_catname}}', $currentCat->name, $metas[$type]);
                    }
                }
            } elseif ($this->type === 'ad') {
                $metas = [
                    'metaTitle' => $legend->advs_title,
                    'metaDesc' => $legend->advs_description,
                ];

                foreach ($metas as $type => $meta) {
                    $ad = $advRepository->find($this->adID);
                    $cats = $advRepository->getCategoriesWithAdID($this->adID);

                    // Check for current & prev cat name
                    if (Str::contains($metas[$type], ['{{current_catname}}', '{{previous_catname}}'])) {
                        if ($currentCat = $categoryRepository->find(end($cats))) {
                            $metas[$type] = str_replace('{{current_catname}}', $currentCat->name, $metas[$type]);
                            $metas[$type] = str_replace('{{previous_catname}}', $currentCat->getParent()->name, $metas[$type]);
                        }
                    }

                    // Check for cat:id names
                    foreach ($cats as $level => $id) {
                        if (Str::contains($metas[$type], "{{{$level}_name}}")) {
                            if ($catName = $categoryRepository->find($id)) {
                                $metas[$type] = str_replace("{{{$level}_name}}", $catName->name, $metas[$type]);
                            }
                        }
                    }

                    // Check for city, district, neighborhood and village names
                    $locations = [
                        'getCity' => 'city_name',
                        'getDistrict' => 'district_name',
                        'getNeighborhood' => 'neighborhood_name',
                        'getVillage' => 'village_name'
                    ];
                    foreach ($locations as $function => $location) {
                        if (Str::contains($metas[$type], "{{{$location}}}")) {
                            $metas[$type] = str_replace("{{{$location}}}", $ad->$function(), $metas[$type]);
                        }
                    }

//                    if (is_module_installed('visiosoft.module.customfields')) {
//                        $adCFs = dispatch_now(new GetCFsByAdID($this->adID));
//                        foreach ($adCFs as $cf) {
//                            TODO...
//                        }
//                    }
                }
            } else {
                return false;
            }

            return $metas;
        }
        return false;
    }
}
