<?php namespace Visiosoft\SelectedCfExtension\SelectedCf;

use Visiosoft\SelectedCfExtension\SelectedCf\Contract\SelectedCfRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use function Visiosoft\SelectedCfExtension\SelectedCf\searchArrayById;

class SelectedCfRepository extends EntryRepository implements SelectedCfRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SelectedCfModel
     */
    protected $model;

    /**
     * Create a new SelectedCfRepository instance.
     *
     * @param SelectedCfModel $model
     */
    public function __construct(SelectedCfModel $model)
    {
        $this->model = $model;
    }

    public function searchArrayById($array, $id)
    {
        foreach ($array as $item) {
            if ($item['customfield_value'] == $id) {
                return true;
            }
        }
        return null;
    }

    public function search($custom_fields, $cats)
    {
        $default_cfs = $this->newQuery()->whereHas('category', function ($category) use ($cats) {
            $category->whereIn('related_id', $cats);
        })->get();


        foreach ($custom_fields as $key => $cf) {
            foreach ($cf['field_types'] as $type) {
                if ($this->searchArrayById($default_cfs, $type['id'])) {
                    $cf['default_value'] = $type['id'];
                    $cf['field_type']->options = [$type['id'] => $type['custom_field_value']];
                    $cf['custom_field_input'] = view('visiosoft.extension.selected_cf::dropdown')->with('field_type', $cf['field_type'])->render();
                }
            }
            $custom_fields[$key] = $cf;
        }
        return $custom_fields;
    }
}
