<?php namespace Visiosoft\SelectedCfExtension\SelectedCf;

use Visiosoft\CustomfieldsModule\Cfvalue\CfvalueModel;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Visiosoft\SelectedCfExtension\SelectedCf\Contract\SelectedCfInterface;
use Anomaly\Streams\Platform\Model\SelectedCf\SelectedCfSelectedCfEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SelectedCfModel extends SelectedCfSelectedCfEntryModel implements SelectedCfInterface
{
    use HasFactory;

    /**
     * @return SelectedCfFactory
     */

    public function cfield(){
        return $this->belongsTo(CustomFieldModel::class, 'customfield');
    }

    public function cfieldvalue(){
        return $this->belongsTo(CfvalueModel::class, 'customfield_value');
    }
    public function getCustomFieldName(){
        return $this->cfield->name;
    }

    public function getCustomFieldValueName(){
        return $this->cfieldvalue->custom_field_value;
    }
    protected static function newFactory()
    {
        return SelectedCfFactory::new();
    }
}
