<?php namespace Visiosoft\SelectedCfExtension\SelectedCf\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class SelectedCfFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'category',
        'customfield',
        'customfield_value'
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'wrapper_view' => 'visiosoft.extension.selected_cf::blank'
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'scripts.js' => [
            'visiosoft.extension.selected_cf::js/selected_cf.js'
        ],
        'styles.css' => [
            'visiosoft.extension.selected_cf::css/selected_cf.css',
        ],
    ];

}
