<?php namespace Visiosoft\SelectedCfExtension\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Visiosoft\SelectedCfExtension\SelectedCf\Form\SelectedCfFormBuilder;
use Visiosoft\SelectedCfExtension\SelectedCf\Table\SelectedCfTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class SelectedCfController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param SelectedCfTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(SelectedCfTableBuilder $table)
    {
        $table->setColumns([
            'category' => [
                'value' => function (EntryModel $entry) {

                    $categories = $entry->category->all();
                    $catNames = array();
                    foreach ($categories as $cat) {
                        $catNames[] = "<div>" . $cat->name . "</div>";
                    }
                    return implode("", $catNames);
                }
            ],
            'customfield' => [
                'value' => function(EntryModel $entry){
                    return "<div>" . $entry->getCustomFieldName() . "</div>";
                }
            ],
            'customfield_value' => [
                'value' => function (EntryModel $entry ) {
                    return "<div>" . $entry->getCustomFieldValueName() . "</div>";
                }
            ],
        ]);


        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param SelectedCfFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(SelectedCfFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param SelectedCfFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(SelectedCfFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
