<?php namespace Visiosoft\SelectedCfExtension\Handler;

use Anomaly\SelectFieldType\SelectFieldType;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class SelectedCustomFieldValueHandler
{
    private $cfvalueRepository;
    private $customFieldRepository;

    public function __construct(
        CfvalueRepositoryInterface $cfvalueRepository,
        CustomFieldRepositoryInterface $customFieldRepository
    )
    {
        $this->cfvalueRepository = $cfvalueRepository;
        $this->customFieldRepository = $customFieldRepository;
    }

    public function handle(SelectFieldType $fieldType)
    {
        $customfields = $this->customFieldRepository->getCustomFieldByType('select');

        $options = $customfields->pluck('name','id')->all();
        $fieldType->setOptions($options);
    }
}