<?php namespace Visiosoft\SearchbydistanceModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Options\OptionsAdvertisementEntryModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Visiosoft\AdvsModule\Adv\AdvRepository;

class SearchbydistanceModuleSeeder extends Seeder
{
    /**
     * Run the seeder.
     */
    public function run()
    {
        Schema::table('advs_advs', function (Blueprint $table) {
            $table->geometry('coor')->nullable();
        });

        $allAdv = DB::table('advs_advs')->get();

        foreach ($allAdv as $adv) {
            if ($map_val = $adv->map_Val) {
                $map_val = explode(',', $adv->map_Val);

                DB::table('advs_advs')
                    ->where('id', $adv->id)
                    ->update([
                        'coor' => DB::raw('ST_PointFromText(\'POINT(' . $map_val[0] . ' ' . $map_val[1] . ')\')')
                    ]);
            }
        }
    }
}
