<?php namespace Visiosoft\SatisModule\Console;

use Illuminate\Console\Command;
use Visiosoft\SatisModule\Event\CheckSatisStatus;
use Visiosoft\SatisModule\Task\Contract\TaskRepositoryInterface;

class CheckSatis extends Command
{
    protected $name = 'check:satis';

    public function handle(TaskRepositoryInterface $taskRepository)
    {

        $username = setting_value('visiosoft.module.satis::username');
        $token = setting_value('visiosoft.module.satis::token');
        $check_url = setting_value('visiosoft.module.satis::control_url');

        $tasks = $taskRepository->newQuery()->where('pending', true)->get();
        foreach ($tasks as $task) {
            $endpoint = "https://" . $username . ":" . $token . "@" .
                $check_url . "&xpath=//build[queueId=" . $task->queue_id . "]";

            $response = event(new CheckSatisStatus($task->queue_id, $endpoint));

            if (!is_null($response) and isset($response[0]['result'])) {
                $status = false;
                if ($response[0]['result'] == "SUCCESS") {
                    $status = true;
                }
                $task->update([
                    'status' => $status,
                    'pending' => false
                ]);
            }
        }
    }

}
