<?php namespace Visiosoft\SatisModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Visiosoft\SatisModule\Event\CheckSatisStatus;
use Visiosoft\SatisModule\Event\UpdateSatis;
use Visiosoft\SatisModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\SatisModule\Task\Table\TaskTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class TaskController extends AdminController
{
    private $token;
    private $username;
    private $endpoint_url;
    private $check_url;
    private $token_parameter;
    private $task;

    public function __construct(TaskRepositoryInterface $task)
    {
        $this->task = $task;
        $this->username = setting_value('visiosoft.module.satis::username');
        $this->token = setting_value('visiosoft.module.satis::token');
        $this->endpoint_url = setting_value('visiosoft.module.satis::url');
        $this->check_url = setting_value('visiosoft.module.satis::control_url');
        $this->token_parameter = setting_value('visiosoft.module.satis::token_parameter');
        parent::__construct();
    }

    public function index(TaskTableBuilder $table)
    {
        $table = $table->setColumns([
            'queue_id',
            'status' => [
                'value' => function (EntryModel $entry) {
                    if ($entry->status) {
                        return "<i class='fa fa-check text-success'></i>";
                    } elseif ($entry->pending == false and $entry->status == false) {
                        return "<i class='fa fa-times text-danger'></i>";
                    }
                }
            ],
            'pending' => [
                'value' => function (EntryModel $entry) {
                    if ($entry->pending) {
                        return "<i class='fa fa-clock-o'></i>";
                    }
                }
            ],
        ]);
        return $table->render();
    }

    public function satis($type)
    {
        if (!is_null($type)) {
            $endpoint = "http://" . $this->username . ":" . $this->token . "@" . $this->endpoint_url;
            $token = $this->token_parameter;
            $git_pull = "false";
            if ($type == "git_pull") {
                $git_pull = "true";
            }
            $response_id = event(new UpdateSatis($git_pull, $endpoint, $token));
            $this->task->create([
                'queue_id' => array_first($response_id),
            ]);

            $this->messages->success(trans('streams::message.edit_success', ['name' => 'Satis']));
            return $this->redirect->to('/admin/satis');
        }
    }
}
