<?php namespace Visiosoft\SatisModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsCheckSatis;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsUpdate;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsUpdateSatis;
use Visiosoft\SatisModule\Event\CheckSatisStatus;
use Visiosoft\SatisModule\Event\UpdateSatis;
use Visiosoft\SatisModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\SatisModule\Task\TaskRepository;
use Anomaly\Streams\Platform\Model\Satis\SatisTaskEntryModel;
use Visiosoft\SatisModule\Task\TaskModel;
use Illuminate\Routing\Router;

class SatisModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/satis' => 'Visiosoft\SatisModule\Http\Controller\Admin\TaskController@index',
        'admin/satis/{type}' => 'Visiosoft\SatisModule\Http\Controller\Admin\TaskController@satis',
        'cron/satis' => 'Visiosoft\SatisModule\Http\Controller\Admin\TaskController@checkSatis',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\SatisModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\SatisModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        UpdateSatis::class => [
            JenkinsUpdateSatis::class
        ],
        CheckSatisStatus::class => [
            JenkinsCheckSatis::class
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\SatisModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        SatisTaskEntryModel::class => TaskModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        TaskRepositoryInterface::class => TaskRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
