<?php namespace Visiosoft\SatisModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\SatisModule\Event\CheckSatisStatus;
use Visiosoft\SatisModule\Task\Contract\TaskRepositoryInterface;

class TaskController extends ResourceController
{
    private $token;
    private $username;
    private $endpoint_url;
    private $check_url;
    private $token_parameter;
    private $task;

    public function __construct(TaskRepositoryInterface $task)
    {
        $this->task = $task;
        $this->username = setting_value('visiosoft.module.satis::username');
        $this->token = setting_value('visiosoft.module.satis::token');
        $this->endpoint_url = setting_value('visiosoft.module.satis::url');
        $this->check_url = setting_value('visiosoft.module.satis::control_url');
        $this->token_parameter = setting_value('visiosoft.module.satis::token_parameter');
        parent::__construct();
    }




    public function checkSatis()
    {
        $tasks = $this->task->newQuery()->where('pending', true)->get();
        foreach ($tasks as $task) {
            $endpoint = "http://" . $this->username . ":" . $this->token . "@" .
                $this->check_url . "&xpath=//build[queueId=" . $task->queue_id . "]";

            $response = event(new CheckSatisStatus($task->queue_id, $endpoint));

            if (!is_null($response) and isset($response[0]['result'])) {
                $status = false;
                if ($response[0]['result'] == "SUCCESS") {
                    $status = true;
                }
                $task->update([
                    'status' => $status,
                    'pending' => false
                ]);
            }
        }
    }
}
