<?php namespace Visiosoft\SahibindenTheme;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\VariablesModule\Variable\Contract\VariableRepositoryInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Anomaly\NavigationModule\Menu\MenuRepository;
use Anomaly\NavigationModule\Link\LinkModel;
use Anomaly\UrlLinkTypeExtension\UrlLinkTypeModel;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Input\ArgvInput;
use Visiosoft\SahibindenTheme\seed\SahibindenFooterSeeder;
use Visiosoft\SahibindenTheme\seed\SahibindenRepeaterSeeder;
use Visiosoft\SliderModule\Slider\Contract\SliderRepositoryInterface;

class SahibindenThemeSeeder extends Seeder
{
    private $settingRepository;
    private $streamRepository;
    private $fieldRepository;
    private $assignmentRepository;
    private $variableRepository;

    public function __construct(SettingRepositoryInterface $settingRepository,
                                StreamRepositoryInterface $streamRepository,
                                FieldRepositoryInterface $fieldRepository,
                                AssignmentRepositoryInterface $assignmentRepository,
                                VariableRepositoryInterface $variableRepository
    )
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
        $this->streamRepository = $streamRepository;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->variableRepository = $variableRepository;
    }

    public function run()
    {
        // Activate
        $this->settingRepository->set('streams::standard_theme', 'visiosoft.theme.sahibinden');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_bottom', '<p><img alt="Banner2" src="/files/images/banner2.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_top_latestAds', '<p><img alt="Banner1" src="/files/images/banner1.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_bottom_latestAds', '<p><img alt="Banner3" src="/files/images/banner3.png"></p>');
        $this->settingRepository->set('visiosoft.extension.sahibinden_style_provider::detail_bottom', '<p><img alt="Banner4" src="/files/images/banner_gif.gif"></p>');
        $this->settingRepository->set('visiosoft.extension.sahibinden_style_provider::detail_bottom_mobile', '<p><img alt="Banner4" src="/files/images/detail_banner_mobile.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_bottom_left_categories', '<p><img alt="Group 41701" src="/files/images/Group_41701.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::banner_web', '1295');

        $menus = [[
            'en' => [
                'name' => 'Customer Service'
            ],
            'slug' => 'customer_service',
        ], [
            'en' => [
                'name' => 'About Us',
            ],
            'slug' => 'about_us',
        ], [
            'en' => [
                'name' => 'Buy And Sell',
            ],
            'slug' => 'buy_and_sell',
        ]];

        $menuRepository = app(MenuRepository::class);
        foreach ($menus as $menu) {
            if (!$menuRepository->findBySlug($menu['slug'])) {
                $menuRepository->create($menu);
            }
        }

        $links = [[
            'entry' => [
                'en' => [
                    'title' => 'OpenClassify.com',
                ],
                'url' => 'https://openclassify.com/',
            ],
            'menu' => 'customer_service'
        ], [
            'entry' => [
                'en' => [
                    'title' => 'Ocify.co',
                ],
                'url' => 'https://ocify.co/',
            ],
            'menu' => 'about_us'
        ], [
            'entry' => [
                'en' => [
                    'title' => 'Visiosoft Inc.',
                ],
                'url' => 'https://visiosoft.com.tr/',
            ],
            'menu' => 'buy_and_sell'
        ]];

        $linkModel = new LinkModel();
        foreach ($links as $link) {
            $menu = $menuRepository->findBySlug($link['menu']);
            $url = new UrlLinkTypeModel();

            $entry = $url->newQuery()->create($link['entry']);

            $linkModel->newQuery()->create([
                'menu' => $menu,
                'target' => '_blank',
                'entry' => $entry,
                'type' => 'anomaly.extension.url_link_type',
            ]);
        }


        // Variables Seed
        if (!$stream = $this->streamRepository->findBySlugAndNamespace('sahibinden_theme', 'variables')) {
            $stream = $this->streamRepository->newQuery()
                ->create([
                    'name' => 'sahibinden-theme',
                    'namespace' => 'variables',
                    'slug' => 'sahibinden_theme',
                    'prefix' => 'variables_',
                    'translatable' => true,
                ]);
        }

        $fields = [
            [
                'name' => 'sahibinden footer text',
                'namespace' => 'variables',
                'slug' => 'sahibinden_footer_text',
                'type' => 'anomaly.field_type.textarea',
                'config' => 'a:6:{s:4:"rows";s:1:"6";s:3:"min";N;s:3:"max";N;s:12:"show_counter";b:0;s:8:"autogrow";b:1;s:13:"default_value";s:330:"The ad creator is solely responsible for the content, correctness, accuracy and legal obligation of all posted ads, entries, ideas and information. openclassify.com is not in any way responsible for the quality or legality of content created and posted by its users. You should contact the ad creator directly with your questions.";}',
                'locked' => false,
            ],
            [
                'name' => 'sahibinden whatsapp text',
                'namespace' => 'variables',
                'slug' => 'sahibinden_wp_text',
                'type' => 'anomaly.field_type.textarea',
                'config' => 'a:6:{s:4:"rows";s:1:"6";s:3:"min";N;s:3:"max";N;s:12:"show_counter";b:0;s:8:"autogrow";b:1;s:13:"default_value";s:330:"Hey look what i found in openclassify ";}',
                'locked' => false,
            ],
            [
                'name' => 'sahibinden security text',
                'namespace' => 'variables',
                'slug' => 'sahibinden_security_text',
                'type' => 'anomaly.field_type.textarea',
                'config' => 'a:6:{s:4:"rows";s:1:"6";s:3:"min";N;s:3:"max";N;s:12:"show_counter";b:0;s:8:"autogrow";b:1;s:13:"default_value";s:330:"Do not make down-payment or send money before seeing the real-estate you want to buy.";}',
                'locked' => false,
            ]
        ];

        foreach ($fields as $field) {

            if (!$this->fieldRepository->findBySlugAndNamespace($field['slug'], 'variables')) {
                $item = $this->fieldRepository->newQuery()
                    ->create([
                        'name' => $field['name'],
                        'namespace' => $field['namespace'],
                        'slug' => $field['slug'],
                        'type' => $field['type'],
                        'config' => $field['config'],
                        'locked' => $field['locked'],
                    ]);

            }

            if (isset($item) && !$this->assignmentRepository->findByStreamAndField($stream, $item)) {
                $this->assignmentRepository->newQuery()
                    ->create([
                        'stream_id' => $stream->id,
                        'field_id' => $item->id,
                        'translatable' => true,
                    ]);
            }
        }

        $this->call(SahibindenFooterSeeder::class);
        $this->call(SahibindenRepeaterSeeder::class);

        $zip = new \ZipArchive();
        $zip->open(realpath(dirname(__DIR__)) . '/src/seed/data/images.zip', \ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/' . app(Application::class)->getReference() . '/files-module/local/images/'));
        $zip->close();

        $application_reference = (new ArgvInput())->getParameterOption('--app', env('APPLICATION_REFERENCE', 'default'));
        $banner = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/banner.sql'));
        Model::unguard();
        DB::unprepared($banner);
        Model::reguard();


        Artisan::call('assets:clear');
        Artisan::call('files:sync');

    }
}
