<?php namespace Visiosoft\SahibindenTheme;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Support\Facades\Artisan;
use Anomaly\NavigationModule\Menu\MenuRepository;
use Anomaly\NavigationModule\Link\LinkModel;
use Anomaly\UrlLinkTypeExtension\UrlLinkTypeModel;

class SahibindenThemeSeeder extends Seeder
{
    private $settingRepository;

    public function __construct(SettingRepositoryInterface $settingRepository)
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
    }

    public function run()
    {
        // Activate
        $this->settingRepository->set('streams::standard_theme', 'visiosoft.theme.sahibinden');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_bottom', '<p><img alt="Banner2" src="/files/images/banner2.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_top_latestAds', '<p><img alt="Banner1" src="/files/images/banner1.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_bottom_latestAds', '<p><img alt="Banner3" src="/files/images/banner3.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_bottom_left_categories', '<p><img alt="Group 41701" src="/files/images/Group_41701.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::banner_web', '1295');

        $menus = [[
            'en' => [
                'name' => 'Customer Service'
            ],
            'slug' => 'customer_service',
        ], [
            'en' => [
                'name' => 'About Us',
            ],
            'slug' => 'about_us',
        ], [
            'en' => [
                'name' => 'Buy And Sell',
            ],
            'slug' => 'buy_and_sell',
        ]];

        $menuRepository = app(MenuRepository::class);
        foreach ($menus as $menu) {
            if (!$menuRepository->findBySlug($menu['slug'])){
                $menuRepository->create($menu);
            }
        }

        $links = [[
            'entry'=> [
                'en' => [
                    'title' => 'OpenClassify.com',
                ],
                'url' => 'https://openclassify.com/',
            ],
            'menu' => 'customer_service'
        ],[
            'entry' => [
                'en' => [
                    'title' => 'Ocify.co',
                ],
                'url' => 'https://ocify.co/',
            ],
            'menu' => 'about_us'
        ],[
            'entry' => [
                'en' => [
                    'title' => 'Visiosoft Inc.',
                ],
                'url' => 'https://visiosoft.com.tr/',
            ],
            'menu' => 'buy_and_sell'
        ]];

        $linkModel = new LinkModel();
        foreach ($links as $link) {
            $menu = $menuRepository->findBySlug($link['menu']);
            $url = new UrlLinkTypeModel();

            $entry = $url->newQuery()->create($link['entry']);

            $linkModel->newQuery()->create([
                'menu' => $menu,
                'target' => '_blank',
                'entry' => $entry,
                'type' => 'anomaly.extension.url_link_type',
            ]);
        }

        $zip = new \ZipArchive();
        $zip->open(realpath(dirname(__DIR__)). '/src/seed/data/images.zip', \ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/'.app(Application::class)->getReference().'/files-module/local/images/'));
        $zip->close();

        Artisan::call('assets:clear');
    }
}
