<?php namespace Visiosoft\SahibindenModule\Http\Controller\Admin;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Illuminate\Http\Request;
use Visiosoft\BotModule\Http\Controller\ScrapesController;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ProductController extends AdminController
{
    private $settingRepository;
    private $scrapesController;

    public function __construct(
        SettingRepositoryInterface $settingRepository,
        ScrapesController $scrapesController
    )
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
        $this->scrapesController = $scrapesController;
    }

    public function index(FormBuilder $form, Request $request)
    {
        set_time_limit(0);
        if ($request->action == "save") {
            $response = $this->getPaginationLinks($request->url);
            $this->messages->success(trans('visiosoft.module.sahibinden::message.get_pagination_success', ['number' => $response]));
            return redirect('/admin/sahibinden');
        }
        $form->setActions(['save']);
        $form->setFields([
            'url' => 'anomaly.field_type.url',
        ]);
        return $form->render();
    }

    public function getPaginationLinks($url)
    {
        $pageLinks = array($url);
        $next = $url;
        $host = parse_url($url);
        $domain = $host['scheme'] . '://' . $host['host'];
        do {
            $xpath = $this->curl($next);
            $next = $xpath->query("//ul[contains(concat(' ', normalize-space(@class), ' '), ' pageNaviButtons ')]/li[last()]/a[contains(concat(' ', normalize-space(@class), ' '), ' prevNextBut ')]");
            $next = $next->item(0) ? $next->item(0)->getAttribute('href') : null;
            if (!is_null($next)) {
                $next = $domain . $next;
                $pageLinks[] = $next;
            }
        } while ($next);

        // Register Pagination Links in Bot Module
        foreach ($pageLinks as $pageLink) {
            $this->scrapesController->registerScrape($pageLink, 'pagination', 'sahibinden');
        }

        return count($pageLinks);
    }

    public function curl($url)
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://api.scraperapi.com/?api_key=' . $this->settingRepository->value('visiosoft.module.sahibinden::scraperapi_key') . '&url=' . $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $doc = new \DOMDocument;
            libxml_use_internal_errors(true);
            $doc->loadHTML($response);
            $xpath = new \DOMXPath($doc);
            return $xpath;
        }
    }

    public function cron()
    {
        return $this->view->make('visiosoft.module.sahibinden::cron');
    }
}
