<?php namespace Visiosoft\SahibindenModule\Http\Controller;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Model\Cats\CatsCategoryEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Customfields\CustomfieldsCfvalueEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Location\LocationCitiesEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Location\LocationDistrictsEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Location\LocationNeighborhoodsEntryTranslationsModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\BotModule\Http\Controller\ScrapesController;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;
use Visiosoft\LocationModule\District\Contract\DistrictRepositoryInterface;
use Visiosoft\LocationModule\Neighborhood\Contract\NeighborhoodRepositoryInterface;
use Visiosoft\ProfileModule\Profile\Contract\ProfileRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\SahibindenModule\Field\Contract\FieldRepositoryInterface;

class ProductController extends PublicController
{
    private $userRepository;
    private $fileRepository;
    private $str;
    private $settingRepository;
    private $scrapesController;
    private $profileRepository;
    private $advRepository;
    private $categoryRepository;
    private $categoryEntryTranslationsModel;
    private $cityRepository;
    private $citiesEntryTranslationsModel;
    private $districtRepository;
    private $districtsEntryTranslationsModel;
    private $neighborhoodRepository;
    private $neighborhoodsEntryTranslationsModel;
    private $fieldRepository;
    private $customFieldAdvRepository;
    private $customFieldRepository;
    private $cfvalueRepository;
    private $cfvalueEntryTranslationsModel;

    public function __construct(
        UserRepositoryInterface $userRepository,
        FileRepositoryInterface $fileRepository,
        Str $str,
        SettingRepositoryInterface $settingRepository,
        ScrapesController $scrapesController,
        ProfileRepositoryInterface $profileRepository,
        AdvRepositoryInterface $advRepository,
        CategoryRepositoryInterface $categoryRepository,
        CatsCategoryEntryTranslationsModel $categoryEntryTranslationsModel,
        CityRepositoryInterface $cityRepository,
        LocationCitiesEntryTranslationsModel $citiesEntryTranslationsModel,
        DistrictRepositoryInterface $districtRepository,
        LocationDistrictsEntryTranslationsModel $districtsEntryTranslationsModel,
        NeighborhoodRepositoryInterface $neighborhoodRepository,
        LocationNeighborhoodsEntryTranslationsModel $neighborhoodsEntryTranslationsModel,
        FieldRepositoryInterface $fieldRepository,
        CustomFieldAdvRepositoryInterface $customFieldAdvRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        CfvalueRepositoryInterface $cfvalueRepository,
        CustomfieldsCfvalueEntryTranslationsModel $cfvalueEntryTranslationsModel
    )
    {
        parent::__construct();
        $this->userRepository = $userRepository;
        $this->fileRepository = $fileRepository;
        $this->str = $str;
        $this->settingRepository = $settingRepository;
        $this->scrapesController = $scrapesController;
        $this->profileRepository = $profileRepository;
        $this->advRepository = $advRepository;
        $this->categoryRepository = $categoryRepository;
        $this->categoryEntryTranslationsModel = $categoryEntryTranslationsModel;
        $this->cityRepository = $cityRepository;
        $this->citiesEntryTranslationsModel = $citiesEntryTranslationsModel;
        $this->districtRepository = $districtRepository;
        $this->districtsEntryTranslationsModel = $districtsEntryTranslationsModel;
        $this->neighborhoodRepository = $neighborhoodRepository;
        $this->neighborhoodsEntryTranslationsModel = $neighborhoodsEntryTranslationsModel;
        $this->fieldRepository = $fieldRepository;
        $this->customFieldAdvRepository = $customFieldAdvRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->cfvalueRepository = $cfvalueRepository;
        $this->cfvalueEntryTranslationsModel = $cfvalueEntryTranslationsModel;
    }

    public function getAdsLinks()
    {
        $paginationUrls = $this->scrapesController->getScrappedPages('pagination', 'sahibinden');

        $numLinks = array();
        foreach ($paginationUrls as $paginationUrl) {
            $scrape = $this->scrapesController->curl($paginationUrl['url']);
            $doc = new \DOMDocument;
            libxml_use_internal_errors(true);
            $doc->loadHTML($scrape['response']);
            $xpath = new \DOMXPath($doc);
            $adsLinks = $xpath->query('//table/tbody/tr/td[1]/a');
            foreach ($adsLinks as $adLink) {
                $link = $adLink->getAttribute('href');
                $link = strpos($link, "http") === 0 ? $link : 'https://www.sahibinden.com' . $link;
                $link = $this->addScraperApiLink($link);
                $this->scrapesController->registerScrape($link, 'page', 'sahibinden');
                $numLinks[] = $link;
            }
            $paginationUrl->update([
                'processed' => 1
            ]);
        }

        echo count($numLinks) . " ad(s) has been found!";
    }

    public function addScraperApiLink($url)
    {
        return 'http://api.scraperapi.com/?api_key=' . $this->settingRepository->value('visiosoft.module.sahibinden::scraperapi_key') .
                '&render=' .  $this->settingRepository->value('visiosoft.module.sahibinden::render') .
                '&country_code=' .  $this->settingRepository->value('visiosoft.module.sahibinden::country_code').
                '&url=' . $url;
    }

    function getAdDetails()
    {
        $pagesUrls = $this->scrapesController->getScrappedPages('page', 'sahibinden');
        $createdAds = array();

        foreach ($pagesUrls as $pageUrl) {
            $adDetails = array();

            $scrape = $this->scrapesController->curl($pageUrl->url);

            $doc = new \DOMDocument;
            libxml_use_internal_errors(true);
            $doc->loadHTML($scrape['response']);
            $xpath = new \DOMXPath($doc);

            // Check if the ad expired
            $expired = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedExpired ')]");
            if ($expired->count() === 1) {
                $pageUrl->update([
                    'processed' => 2
                ]);
                // Delete ad if available
                $this->disapproveExpiredAds($pageUrl->url);
            } else {
                $adId = $xpath->query('//*[@id="classifiedId"]');
                if ($adId->count() === 1) {
                    $adId = $adId->item(0)->nodeValue;

                    $username = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' username-info-area ')]/h5");
                    $username = $username->item(0) ?
                        $username->item(0)->nodeValue :
                        $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' username-info-area ')]/p")->item(0)->nodeValue;

                    $desc = $xpath->query('//*[@id="classifiedDescription"]');
                    $desc = $desc->item(0)->nodeValue;

                    $productName = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedDetailTitle ')]/h1");
                    $productName = $productName->item(0)->nodeValue;

                    $price = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedInfo ')]/h3/text()");
                    if (!count($price)) {
                        $priceWhole = $xpath->query("//span[contains(concat(' ', normalize-space(@class), ' '), ' price-value ')]/text()");
                        $priceWhole = trim(preg_replace('/\s+/', ' ', $priceWhole->item(0)->data));
                        $priceFractional = $xpath->query("//span[contains(concat(' ', normalize-space(@class), ' '), ' price-value ')]/sup");
                        $priceFractional = $priceFractional->item(0)->nodeValue;
                        $currency = $xpath->query("//span[contains(concat(' ', normalize-space(@class), ' '), ' currency ')]");
                        $currency = $currency->item(0)->nodeValue;
                        $price = [
                            $priceWhole . $priceFractional,
                            $currency
                        ];
                    } else {
                        $priceFractional = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedInfo ')]/h3/sup");
                        if (count($priceFractional)) {
                            $priceFractional = $priceFractional->item(0)->nodeValue;
                        } else {
                            $priceFractional = "";
                        }
                        $price = $price->item(0)->nodeValue;
                        $price = array_filter(explode(' ', $price));
                        unset($price[0]);
                        sort($price);
                        if (!is_numeric($price[0])) {
                            $price = array_reverse($price);
                        }
                        $price[0] = str_replace('.', '', $price[0]) . $priceFractional;
                    }

                    $locations = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedInfo ')]/h2/a");
                    $adLocation = array();
                    foreach ($locations as $location) {
                        $adLocation[] = preg_replace('/\s+/', '', $location->nodeValue);
                    }

                    $phone = $xpath->query('//*[@id="phoneInfoPart"]/li/span[1]');
                    $phone = $phone->item($phone->length - 1) ? $phone->item($phone->length - 1)->nodeValue : 'No Phone Number';

                    $categories = $xpath->query('//*[@id="uiBreadCrumb"]/li/a');

                    $adCategory = array();
                    foreach ($categories as $key => $category) {
                        $adCategory[] = preg_replace('/\s+/', '', $category->nodeValue);
                    }
                    if ($adCategory[0] === "Anasayfa" || $adCategory[0] === "Home") {
                        array_shift($adCategory);
                    }

                    $images = array();
                    $photos = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedDetailThumbListContainer ')]/ul/li/ul/li/label/img");
                    foreach ($photos as $photo) {
                        $newImage = array();
                        $imagePath = $photo->getAttribute('src');
                        $newImage['thmb'] = $imagePath;
                        $newImage['org'] = substr($imagePath, 0, strpos($imagePath, "thmb")) . "x5" . substr($imagePath, strpos($imagePath, "thmb") + 4);
                        $images[] = $newImage;
                    }

                    $customFields = array();
                    $classifiedInfoListKeys = $xpath->query("//ul[contains(concat(' ', normalize-space(@class), ' '), ' classifiedInfoList ')]/li/strong/text()");
                    $classifiedInfoListValues = $xpath->query("//ul[contains(concat(' ', normalize-space(@class), ' '), ' classifiedInfoList ')]/li/span/text()");
                    for ($i = 0; $i < count($classifiedInfoListKeys); $i++) {
                        $fieldName = trim(preg_replace('/\s+/', ' ', $classifiedInfoListKeys->item($i)->data));
                        $customFieldId = $this->fieldRepository->findBy('field_name', $fieldName);
                        if (!is_null($customFieldId)) {
                            $customFields['cf' . $customFieldId->custom_field_id] = trim(preg_replace('/\s+/', ' ', $classifiedInfoListValues->item($i)->data));
                        }
                    }

                    $adDetails['ad_id'] = $adId;
                    $adDetails['cf_json'] = $customFields;
                    $adDetails['price'] = $price;
                    $adDetails['name'] = $productName;
                    $adDetails['desc'] = $desc;
                    $adDetails['city'] = $adLocation[0];
                    if (count($adLocation) > 1) $adDetails['district'] = $adLocation[1];
                    if (count($adLocation) > 2) $adDetails['neighborhood'] = $adLocation[2];
                    $adDetails['phone'] = preg_replace("/[^0-9]/", "", $phone);
                    $adDetails['images'] = $images;
                    $adDetails['category'] = array_slice($adCategory, 0, count($adCategory) - 4);

                    $user = $this->checkUser($username, $phone);
                    $this->postAd($adDetails, $user);

                    $pageUrl->update([
                        'processed' => 1
                    ]);

                    $createdAds[] = $pageUrl->url;
                }
            }
        }

        echo count($createdAds) . " ad(s) has been created!";
    }

    public function checkUser($username, $phoneNum)
    {
        $user = $this->userRepository->findBy('username', $this->str->slug($username, '_'));
        if (is_null($user)) {
            $fullName = explode(" ", $username);
            $user = $this->userRepository->create([
                'username' => $username,
                'first_name' => $fullName[0],
                'last_name' => $fullName[1],
                'display_name' => $username,
                'email' => $this->str->slug($username, "_") . '@user.com',
                'activated' => 1,
            ]);
            $password = str_random(8);
            $user->setAttribute('password', $password);
            $this->userRepository->save($user);

            // Create a profile for the user
            $this->profileRepository->create([
                'user' => $user,
                'gsm_phone' => $phoneNum,
            ]);
        };

        return $user;
    }

    public function postAd($adDetails, $user)
    {
        /* Looping through the categories and creating an array of categories.. ['cat1', 'cat2', etc..] */
        $category = array();
        for ($i = 0; $i < count($adDetails['category']); $i++) {
            $catNumber = $i + 1;
            $cat = $this->categoryEntryTranslationsModel->newQuery()->where('name', $adDetails['category'][$i])->first();
            if (is_null($cat)) {
                $cat = ['id' => null];
//                if ($i !== 0) {
//                    $parentCategory = $this->categoryEntryTranslationsModel->newQuery()->where('name', $adDetails['category'][$i - 1])->first();
//                    $parentCategory = $this->categoryRepository->find($parentCategory->entry_id);
//                } else {
//                    $parentCategory = null;
//                }
//                $nameTranslation = array();
//                foreach (config('streams::locales.enabled') as $locale) {
//                    $nameTranslation[$locale] = [
//                        'name' => $adDetails['category'][$i]
//                    ];
//                }
//                $cat = $this->categoryRepository->create(array_merge($nameTranslation, [
//                    'slug' => $this->str->slug($adDetails['category'][$i], '_'),
//                    'parent_category' => $parentCategory,
//                ]));
            } else {
                $cat = $this->categoryRepository->find($cat->entry_id);
            }

            $category['cat' . $catNumber] = $cat['id'];
        }

        $city = $this->citiesEntryTranslationsModel->newQuery()->where('name', $adDetails['city'])->first();
        if (is_null($city)) {
            $city = $this->cityRepository->create([
                'name' => $adDetails['city'],
                'slug' => $this->str->slug($adDetails['city'], '_'),
                'parent_country_id' => $this->settingRepository->value('visiosoft.module.sahibinden::country_id'),
            ]);
        } else {
            $city = $this->cityRepository->find($city->entry_id);
        }

        if (isset($adDetails['district'])) {
            $district = $this->districtsEntryTranslationsModel
                ->newQuery()
                ->where('name', $adDetails['district'])
                ->first();
            if (is_null($district)) {
                $district = $this->districtRepository->create([
                    'name' => $adDetails['district'],
                    'slug' => $this->str->slug($adDetails['district'], '_'),
                    'parent_city_id' => $city->id,
                ]);
            } else {
                $district = $this->districtRepository->find($district->entry_id);
            }
        }


        if (isset($adDetails['neighborhood'])) {
            $neighborhood = $this->neighborhoodsEntryTranslationsModel
                ->newQuery()
                ->where('name', $adDetails['neighborhood'])
                ->first();
            if (is_null($neighborhood)) {
                $neighborhood = $this->neighborhoodRepository->create([
                    'name' => $adDetails['neighborhood'],
                    'slug' => $this->str->slug($adDetails['neighborhood'], '_'),
                    'parent_district_id' => $district->id,
                ]);
            } else {
                $neighborhood = $this->neighborhoodRepository->find($neighborhood->entry_id);
            }
        }


        if ($adDetails['price'][1] == "€") {
            $currency = "EUR";
        } elseif ($adDetails['price'][1] == "$") {
            $currency = "USD";
        } elseif ($adDetails['price'][1] == "£") {
            $currency = "USD";
        } else {
            $currency = "TRY";
        }

        $date = date('Y-m-d H:i:s');
        $data = [
            'en' => [
                'name' => $adDetails['name'],
                'advs_desc' => $adDetails['desc'],
            ],
            'tr' => [
                'name' => $adDetails['name'],
                'advs_desc' => $adDetails['desc'],
            ],
            'price' => $adDetails['price'][0],
            'country_id' => $this->settingRepository->value('visiosoft.module.sahibinden::country_id'),
            'city' => $city->id,
            'district' => isset($district->id) ? $district->id : null,
            'neighborhood' => isset($neighborhood->id) ? $neighborhood->id : null,
            'slug' => $adDetails['name'] . '_' . $adDetails['ad_id'],
            'currency' => $currency,
            'created_by_id' => $user->id,
            'status' => 'approved',
            'publish_at' => $date,
            'finish_at' => date('Y-m-d H:i:s', strtotime($date . ' + 60 day')),
        ];

        $adv = $this->advRepository
            ->newQuery()
            ->where('slug', 'LIKE', '%_' . $adDetails['ad_id'])
            ->first();
        if (is_null($adv)) {
            $adv = $this->advRepository->create(array_merge($data, $category));
            $adImages = $this->savePhoto($adDetails['images'], $adv->id);
            if (count($adImages) > 0) {
                $adv->update([
                    'cover_photo' => $adImages[0]->url()
                ]);
            }
        } else {
            $adv->update(array_merge($data, $category));
        }

        $jsonCustomFields = $this->createCustomFields($adDetails['cf_json'], $adv);
        $adv->update([
            'cf_json' => $jsonCustomFields
        ]);
    }

    public function createCustomFields($customFields, $ad)
    {
        $jsonCustomFields = array();
        foreach ($customFields as $customFieldId => $customFieldValue) {
            $customField = $this->customFieldAdvRepository
                ->newQuery()
                ->where('parent_adv_id', $ad->id)
                ->where('custom_field_value', $customFieldValue)
                ->first();
            if (is_null($customField)) {
                $customFieldType = $this->customFieldRepository->find(substr($customFieldId, 2));
                if (!is_null($customFieldType)) {
                    if ($customFieldType->type === 'select' || $customFieldType->type === 'radio') {
                        $selectValue = $this->cfvalueEntryTranslationsModel
                            ->newQuery()
                            ->where('custom_field_value', 'LIKE', "%$customFieldValue%")
                            ->first();
                        if (is_null($selectValue)) {
                            $selectValue = $this->cfvalueRepository->create([
                                'custom_field' => $customFieldType,
                                'custom_field_value' => $customFieldValue
                            ]);
                        }
                        $customFieldValue = $selectValue->id;
                    } elseif ($customFieldType->type === 'checkboxes') {
                        $values = array();
                        foreach ($customFieldValue as $value) {
                            $checkboxValue = $this->cfvalueEntryTranslationsModel
                                ->newQuery()
                                ->where('custom_field_value', 'LIKE', "%$value%")
                                ->first();
                            if ($checkboxValue) {
                                $checkboxValue = $this->cfvalueRepository->find($checkboxValue->entry_id);
                                if (is_null($checkboxValue)) {
                                    $checkboxValue = $this->cfvalueRepository->create([
                                        'custom_field' => $customFieldType,
                                        'custom_field_value' => $value
                                    ]);
                                }
                                $values[] = $checkboxValue->id;
                            }
                        }
                        $customFieldValue = $values;
                    }

                    if ($customFieldType->type === 'checkboxes') {
                        $customField = $this->customFieldAdvRepository->create([
                            'parent_adv' => $ad,
                            'custom_field_category' => $customFieldType,
                            'custom_field_value' => json_encode($customFieldValue),
                            'custom_field_type' => $customFieldType->type
                        ]);
                        $jsonCustomFields[$customFieldId] = $customFieldValue;
                    } else {
                        $customField = $this->customFieldAdvRepository->create([
                            'parent_adv' => $ad,
                            'custom_field_category' => $customFieldType,
                            'custom_field_value' => $customFieldValue,
                            'custom_field_type' => $customFieldType->type
                        ]);
                        $jsonCustomFields[$customFieldId] = $customField->id;
                    }
                }
            }
        }
        $jsonCustomFields = json_encode($jsonCustomFields, JSON_UNESCAPED_UNICODE);
        return $jsonCustomFields;
    }

    public function savePhoto($photosUrl, $advId)
    {
        $adImages = array();
        /* Looping through the photo's URLs and saving them */
        foreach ($photosUrl as $photoUrl) {
            $link = $photoUrl['org'];
            $name = basename($link);
            $contents = file_get_contents($link);
            $target = base_path() . "/storage/streams/default/files-module/local/images/" . $name;
            /* Saving the photos in the local storage */
            file_put_contents($target, $contents);
            $file = $this->saveFileInModel($name, $advId);
            DB::table('advs_advs_files')->insert(
                ['file_id' => $file->id, 'entry_id' => $advId]
            );
            $adImages[] = $file;
        }
        return $adImages;
    }

    public function saveFileInModel($filename, $advId)
    {
        return $this->fileRepository->create([
            'folder_id' => 1,
            'name' => $filename,
            'disk_id' => 1,
            'size' => 1,
            'mime_type' => "image/jpeg",
            'extension' => 1,
        ]);
    }

    public function disapproveExpiredAds($adUrl)
    {
        $id = explode('/', parse_url($adUrl)['query']);
        $id = explode('-', $id[count($id) - 2]);
        $id = $id[count($id) - 1];
        $adv = $this->advRepository
            ->newQuery()
            ->where('slug', 'LIKE', '%_' . $id)
            ->first();
        if (!is_null($adv)) {
            $adv->update(['status' => 'pending_user']);
        }
    }
}
