<?php namespace Visiosoft\SahibindenModule\Http\Controller\Admin;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Illuminate\Http\Request;
use Visiosoft\BotModule\Http\Controller\ScrapesController;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ProductController extends AdminController
{
    private $settingRepository;
    private $scrapesController;

    public function __construct(
        SettingRepositoryInterface $settingRepository,
        ScrapesController $scrapesController
    )
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
        $this->scrapesController = $scrapesController;
    }

    public function index(FormBuilder $form, Request $request)
    {
        set_time_limit(0);
        if ($request->action == "save") {
            $response = $this->getPaginationLinks($request->url);
            $this->messages->success(trans('visiosoft.module.sahibinden::message.get_pagination_success', ['number' => $response]));
            return redirect('/admin/sahibinden');
        }
        $form->setActions(['save']);
        $form->setFields([
            'url' => 'anomaly.field_type.url',
        ]);
        return $form->render();
    }

    public function getPaginationLinks($url)
    {
        $next = $this->addScraperApiLink($url);
        $pageLinks = array($next);
        $host = parse_url($url);
        $domain = $host['scheme'] . '://' . $host['host'];
        do {
            $scrape = $this->scrapesController->curl($next);
            $doc = new \DOMDocument;
            libxml_use_internal_errors(true);
            $doc->loadHTML($scrape['response']);
            $xpath = new \DOMXPath($doc);
            $next = $xpath->query("//ul[contains(concat(' ', normalize-space(@class), ' '), ' pageNaviButtons ')]/li[last()]/a[contains(concat(' ', normalize-space(@class), ' '), ' prevNextBut ')]");
            $next = $next->item(0) ? $next->item(0)->getAttribute('href') : null;
            if (!is_null($next)) {
                $next = $domain . $next;
                $pageLinks[] = $this->addScraperApiLink($next);
            }
        } while ($next);

        // Register Pagination Links in Bot Module
        foreach ($pageLinks as $pageLink) {
            $this->scrapesController->registerScrape($pageLink, 'pagination', 'sahibinden');
        }

        return count($pageLinks);
    }

    public function addScraperApiLink($url) {
        return 'http://api.scraperapi.com/?api_key=' . $this->settingRepository->value('visiosoft.module.sahibinden::scraperapi_key') . '&url=' . $url;
    }

    public function cron()
    {
        return $this->view->make('visiosoft.module.sahibinden::cron');
    }
}
