<?php namespace Visiosoft\SahibindenModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\SahibindenModule\Image\Contract\ImageRepositoryInterface;
use Visiosoft\SahibindenModule\Image\ImageRepository;
use Anomaly\Streams\Platform\Model\Sahibinden\SahibindenImagesEntryModel;
use Visiosoft\SahibindenModule\Image\ImageModel;
use Visiosoft\SahibindenModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\SahibindenModule\Product\ProductRepository;
use Anomaly\Streams\Platform\Model\Sahibinden\SahibindenProductEntryModel;
use Visiosoft\SahibindenModule\Product\ProductModel;
use Illuminate\Routing\Router;

class SahibindenModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/sahibinden/save-ads/{id}' => [
            'as' => 'sahibinden::save-ads',
            'uses' => 'Visiosoft\SahibindenModule\Http\Controller\Admin\ProductController@saveAds',
        ],
        'admin/sahibinden/images'           => 'Visiosoft\SahibindenModule\Http\Controller\Admin\ImagesController@index',
        'admin/sahibinden/images/create'    => 'Visiosoft\SahibindenModule\Http\Controller\Admin\ImagesController@create',
        'admin/sahibinden/images/edit/{id}' => 'Visiosoft\SahibindenModule\Http\Controller\Admin\ImagesController@edit',
        'admin/sahibinden'           => 'Visiosoft\SahibindenModule\Http\Controller\Admin\ProductController@index',
        'admin/sahibinden/create'    => 'Visiosoft\SahibindenModule\Http\Controller\Admin\ProductController@create',
        'admin/sahibinden/edit/{id}' => 'Visiosoft\SahibindenModule\Http\Controller\Admin\ProductController@edit',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\SahibindenModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\SahibindenModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\SahibindenModule\Event\ExampleEvent::class => [
        //    Visiosoft\SahibindenModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\SahibindenModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        SahibindenImagesEntryModel::class => ImageModel::class,
        SahibindenProductEntryModel::class => ProductModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ImageRepositoryInterface::class => ImageRepository::class,
        ProductRepositoryInterface::class => ProductRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
