<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSahibindenCreateProductStream extends Migration
{

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'product',
        'title_column' => 'name',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'slug' => [
            'unique' => true,
            'required' => true,
        ],
        'phone' => [],
        'ad_id' => [],
        'desc' => [],
        'city' => [],
        'district' => [],
        'neighborhood' => [],
        'store_url' => [
            'required' => true,
        ],
        'price' => [
            'required' => true,
        ],
        'currency' => [
            'required' => true,
        ],
        'cover_photo',
        'cat1',
        'cat2',
        'cat3',
        'cat4',
        'cat5',
        'cat6',
        'cat7',
        'cat8',
        'cat9',
        'cat10',
        'saved' => [],
        'saved_id',
    ];

}
