<?php namespace Visiosoft\SahibindenModule\Http\Controller\Admin;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\District\DistrictModel;
use Visiosoft\LocationModule\Neighborhood\NeighborhoodModel;
use Visiosoft\ProfileModule\Profile\ProfileModel;
use Visiosoft\SahibindenModule\Image\ImageModel;
use Visiosoft\SahibindenModule\Product\Form\ProductFormBuilder;
use Visiosoft\SahibindenModule\Product\ProductModel;
use Visiosoft\SahibindenModule\Product\Table\ProductTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ProductController extends AdminController
{
    private $model;
    private $users;
    private $postFiles;
    private $str;
    private $image;
    private $settings;

    public function __construct(
        ProductModel $model,
        UserRepositoryInterface $users,
        FileRepositoryInterface $postFiles,
        Str $str,
        ImageModel $image,
        SettingRepositoryInterface $settings
    )
    {
        parent::__construct();
        $this->model = $model;
        $this->users = $users;
        $this->postFiles = $postFiles;
        $this->str = $str;
        $this->image = $image;
        $this->settings = $settings;

        $this->settings->set('visiosoft.module.sahibinden::scraperapi_key', 'd97e8f0d3d1640a12b9c63d54e80f5c4');
    }

    /**
     * Display an index of existing entries.
     *
     * @param ProductTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ProductTableBuilder $table)
    {
        $table->setButtons(array_merge($table->getButtons(), [
            'publish' => [
                'text' => 'visiosoft.module.sahibinden::button.publish.name',
                'href' => '/admin/sahibinden/save-ads/{entry.id}',
                'class' => function (EntryInterface $entry) {
                    if ($entry->saved == 1) {
                        return 'disabled';
                    }
                }
            ]
        ]));
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ProductFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ProductFormBuilder $form, Request $request)
    {
        if ($request->action == "save") {
            $response = $this->getPageLinks($request->store_url);

            // Create a new user based on the user who posted the product
            $user = $this->users->findBy('display_name', $response['store_name']);
            $user = is_null($user) ? $this->createUser($response['store_name'], $response['phone']) : $user;

            $response = $this->postAd($response['ads_detail'], $request->store_url, $user->id);
            $this->messages->success(trans('streams::message.create_success', ['name' => 'Products']));
            return redirect('/admin/sahibinden');
        }
        $form->setActions(['save']);
        $form->setFields([
            'store_url'
        ]);
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ProductFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ProductFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function getPageLinks($store_url = "http://emekyapi.sahibinden.com/")
    {
        $xpath = $this->curl($store_url);
        $links = array();
        $store_perpage_links = $xpath->query("//*[@id=\"container\"]/div[1]/div[3]/div[2]/div/div/ul/li/a");
        if ($store_perpage_links->length > 0) {
            $store_pages = $store_perpage_links->item($store_perpage_links->length - 2)->nodeValue;
            $href = $store_perpage_links->item($store_perpage_links->length - 2)->getAttribute('href');
            for ($i = 0; $i < $store_pages * 20; $i += 20) {
                $links[] = $store_url . parse_url($href)['path'] . "?pagingOffset=" . $i;
            }
            return $this->getAdlinksSahibinden($links);
        } else {
            return $this->getAdlinksSahibinden([$store_url]);
        }
    }

    public function curl($url)
    {
        $ch = curl_init();
        $api_key = $this->settings->value('visiosoft.module.sahibinden::scraperapi_key');
        curl_setopt($ch, CURLOPT_URL, "http://api.scraperapi.com/?api_key=" . $api_key ."&render=true&url=" . $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Accept: application/json"
        ));
        $response = curl_exec($ch);
        $status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $doc = new \DOMDocument;
        libxml_use_internal_errors(true);
        $doc->loadHTML($response);
        $xpath = new \DOMXPath($doc);
        return $xpath;
    }

    public function getAdlinksSahibinden($page_url)
    {
        $ad_links = array();
        foreach ($page_url as $url) {
            $xpath1 = $this->curl($url);
            $store_name = $xpath1->query('/html/head/meta[@name="og:title"]/@content');
            $store_name = $store_name->item(0)->nodeValue;
            $store_ad_links = $xpath1->query("//*[@id=\"container\"]/div[1]/div[3]/div[2]/table/tbody/tr/td[1]/a");
            foreach ($store_ad_links as $link) {
                $d = $link->getAttribute('href');
                if (!in_array($d, $ad_links)) {
                    $ad_links[] = $d;
                }
            }
        }
        return $this->getDetailsSahibinden($ad_links, $store_name);
    }

    function getDetailsSahibinden($links, $store_name)
    {
        $ads_detail = array();
        foreach ($links as $link) {
            $xpath1 = $this->curl($link);
            $ad_id = $xpath1->query("//*[@id=\"classifiedId\"]");
            $ad_id = $ad_id->item(0)->nodeValue;

            $desc = $xpath1->query("//*[@id=\"classifiedDescription\"]");
            $desc = $desc->item(0)->nodeValue;

            $name = $xpath1->query("//*[@id=\"classifiedDetail\"]/div[1]/div[1]/h1");
            $name = $name->item(0)->nodeValue;

            $price = $xpath1->query("//*[@id=\"classifiedDetail\"]/div[1]/div[2]/div[2]/h3/text()");
            $price = $price->item(0)->nodeValue;
            $price = array_filter(explode(' ', $price));
            unset($price[0]);
            sort($price);

            $locations = $xpath1->query("//*[@id=\"classifiedDetail\"]/div[1]/div[2]/div[2]/h2/a");
            $ad_location = array();
            foreach ($locations as $location) {
                $ad_location[] = preg_replace('/\s+/', '', $location->nodeValue);
            }

            $phone = $xpath1->query("//*[@id=\"phoneInfoPart\"]/li/span[1]");
            $phone = $phone->item($phone->length - 1)->nodeValue;

            $categories = $xpath1->query("//*[@id=\"uiBreadCrumb\"]/li/a");

            $ad_category = array();
            foreach ($categories as $key => $category) {
                $ad_category[] = preg_replace('/\s+/', '', $category->nodeValue);
            }

            $images = array();
            $photos = $xpath1->query("//*[@id=\"classifiedDetail\"]/div[1]/div[2]/div[1]/div[2]/ul/li/ul/li/label/img");
            foreach ($photos as $photo) {
                $new_image = array();
                $image_path = $photo->getAttribute('src');
                $new_image['thmb'] = $image_path;
                $new_image['org'] = substr($image_path, 0, strpos($image_path, "thmb")) . "x5" . substr($image_path, strpos($image_path, "thmb") + 4);
                $images[] = $new_image;
            }

            $detail['ad_id'] = $ad_id;
            $detail['price'] = $price;
            $detail['name'] = $name;
            $detail['desc'] = $desc;
            $detail['city'] = $ad_location[0];
            if (count($ad_location) > 1) $detail['district'] = $ad_location[1];
            if (count($ad_location) > 2) $detail['neighborhood'] = $ad_location[2];
            $detail['phone'] = preg_replace("/[^0-9]/", "", $phone);
            $detail['images'] = $images;
            $detail['category'] = array_slice($ad_category, 0, count($ad_category) - 4);
            $ads_detail[$ad_id] = $detail;
        }
        $response = [
            'ads_detail' => $ads_detail,
            'store_name' => $store_name,
            'phone' => reset($ads_detail)['phone']
        ];
        return $response;
    }

    public function postAd($params, $storeUrl, $user_id)
    {
        foreach ($params as $index => $param) {
            /* Looping through the categories and creating an array of categories.. ['cat1', 'cat2', etc..] */
            $category = array();
            for ($i = 0; $i < count($param['category']); $i++) {
                $cat = $i + 1;
                $category['cat' . $cat] = $param['category'][$i];
            }
            /* Getting the cover photo */
            $cover_photo = reset($param['images'])['org'];
            $product = $this->model->newQuery()->where('ad_id', $param['ad_id'])->first();

            $data = [
                'ad_id' => $param['ad_id'],
                'price' => $param['price'][0],
                'currency' => $param['price'][1],
                'name' => $param['name'],
                'desc' => $param['desc'],
                'city' => $param['city'],
                'district' => $param['district'],
                'neighborhood' => $param['neighborhood'],
                'phone' => $param['phone'],
                'store_url' => $storeUrl,
                'cover_photo' => $cover_photo
            ];
            if (is_null($product)) {
                $data['created_by_id'] = $user_id;
                $data['slug'] = $param['name'] . '_' . $param['ad_id'];
                $product = $this->model->create(array_merge($data , $category));
            } else {
                $product = $product->update(array_merge($data, $category));
            }
            $this->savePhoto($param['images'], $product->id);
        }
    }

    public function savePhoto($photosUrl, $productId)
    {
        /* Looping through the photo's URLs and saving them */
        foreach ($photosUrl as $photoUrl) {
            $link = $photoUrl['org'];
            $name = basename($link);
            $contents = file_get_contents($link);
            $target = getcwd() . "/app/default/files-module/local/images/" . $name;
            /* Saving the photos in the local storage */
            file_put_contents($target, $contents);
            $file = $this->saveFileInModel($name);
            /* Create an entry in the vivid table that connects the product with its images */
            $this->image->create([
                'file_id' => $file->id,
                'product_id' => $productId,
            ]);
        }
    }

    public function saveFileInModel($filename)
    {
        return $this->postFiles->newQuery()->create(
            [
                'folder_id' => 1,
                'name' => $filename,
                'disk_id' => 1,
                'size' => 1,
                'mime_type' => "image/jpeg",
                'extension' => 1,
            ]
        );
    }

    public function createUser($username, $phoneNum)
    {
        // Generate random password
        $password = str_random(8);

        // Create user
        $user = $this->users->create(
            [
                'username' => $username,
                'display_name' => $username,
                'email' => $this->str->slug($username, "_") . '@user.com',
                'activated' => 1,
            ]
        );
        $user->setAttribute('password', $password);
        $this->users->save($user);

        /* Create a profile for the user */
        $profile = ProfileModel::query()->create([
            'user_no_id' => $user->getId(),
            'gsm_phone' => $phoneNum,
        ]);

        return $user;
    }

    public function saveAds($id)
    {
        $advs_model = new AdvModel();
        $category_Model = new CategoryModel();
        $city_Model = new CityModel();
        $district_model = new DistrictModel();
        $neighborhood_model = new NeighborhoodModel();

        $product = $this->model->find($id);

        $cat1 = $category_Model->newQuery()->leftJoin('cats_category_translations', function ($join) {
            $join->on('cats_category.id', '=', 'cats_category_translations.entry_id');
        });
        $cat1 = $cat1->where('name', $product->cat1)->first();
        $cat1 = is_null($cat1) ? $cat1 = 1 : $cat1->id;

        $city = $city_Model->where('name', $product->city)->first();
        $city = is_null($city) ? 1 : $city->id;

        $district = $district_model->where('name', $product->district)->first();
        $district = is_null($district) ? 947 : $district->id;

        $neighborhood = $neighborhood_model->where('name', $product->neighborhood)->first();
        $neighborhood = is_null($neighborhood) ? 2 : $neighborhood->id;

        $date = date('Y-m-d H:i:s');

        // first get Id of image (file)
        $imageModel = new ImageModel();
        $images = $imageModel->select('file_id')->where("product_id", $id)->get();

        $saved = $advs_model->create([
            'en' => [
                'name' => $product->name,
                'advs_desc' => $product->desc,
            ],
            'tr' => [
                'name' => $product->name,
                'advs_desc' => $product->desc,
            ],
            'price' => $product->price,
            'country_id' => 212,
            'city' => $city,
            'district' => $district,
            'neighborhood' => $neighborhood,
            'slug' => $product->slug,
            'cat1' => $cat1,
//            'cat2' => $cat2,
            'currency' => $product->currency,
            'cover_photo' => $product->cover_photo,
            'created_by_id' => $product->created_by_id,
            'status' => 'approved',
            'publish_at' => $date,
            'finish_at' => date('Y-m-d H:i:s', strtotime($date . ' + 60 day')),
        ]);

        foreach ($images as $image) {
            DB::table('advs_advs_files')->insert(
                ['file_id' => $image->file_id, 'entry_id' => $saved->id]
            );
        }

        $this->messages->success(trans('streams::message.create_success', ['name' => 'Products']));
        $product->update(['saved' => 1, 'saved_id' => $saved->id]);
        return redirect('/admin/sahibinden');
    }
}
