<?php namespace Visiosoft\SahibindenModule\Http\Controller;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Model\Cats\CatsCategoryEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Location\LocationCitiesEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Location\LocationDistrictsEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Location\LocationNeighborhoodsEntryTranslationsModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\BotModule\Http\Controller\ScrapesController;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;
use Visiosoft\LocationModule\District\Contract\DistrictRepositoryInterface;
use Visiosoft\LocationModule\Neighborhood\Contract\NeighborhoodRepositoryInterface;
use Visiosoft\ProfileModule\Profile\Contract\ProfileRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\SahibindenModule\Field\Contract\FieldRepositoryInterface;

class ProductController extends PublicController
{
    private $userRepository;
    private $postFiles;
    private $str;
    private $settingRepository;
    private $scrapesController;
    private $profileRepository;
    private $advRepository;
    private $categoryRepository;
    private $categoryEntryTranslationsModel;
    private $cityRepository;
    private $citiesEntryTranslationsModel;
    private $districtRepository;
    private $districtsEntryTranslationsModel;
    private $neighborhoodRepository;
    private $neighborhoodsEntryTranslationsModel;
    private $fieldRepository;
    private $customFieldAdvRepository;

    public function __construct(
        UserRepositoryInterface $userRepository,
        FileRepositoryInterface $postFiles,
        Str $str,
        SettingRepositoryInterface $settingRepository,
        ScrapesController $scrapesController,
        ProfileRepositoryInterface $profileRepository,
        AdvRepositoryInterface $advRepository,
        CategoryRepositoryInterface $categoryRepository,
        CatsCategoryEntryTranslationsModel $categoryEntryTranslationsModel,
        CityRepositoryInterface $cityRepository,
        LocationCitiesEntryTranslationsModel $citiesEntryTranslationsModel,
        DistrictRepositoryInterface $districtRepository,
        LocationDistrictsEntryTranslationsModel $districtsEntryTranslationsModel,
        NeighborhoodRepositoryInterface $neighborhoodRepository,
        LocationNeighborhoodsEntryTranslationsModel $neighborhoodsEntryTranslationsModel,
        FieldRepositoryInterface $fieldRepository,
        CustomFieldAdvRepositoryInterface $customFieldAdvRepository
    )
    {
        parent::__construct();
        $this->userRepository = $userRepository;
        $this->postFiles = $postFiles;
        $this->str = $str;
        $this->settingRepository = $settingRepository;
        $this->scrapesController = $scrapesController;
        $this->profileRepository = $profileRepository;
        $this->advRepository = $advRepository;
        $this->categoryRepository = $categoryRepository;
        $this->categoryEntryTranslationsModel = $categoryEntryTranslationsModel;
        $this->cityRepository = $cityRepository;
        $this->citiesEntryTranslationsModel = $citiesEntryTranslationsModel;
        $this->districtRepository = $districtRepository;
        $this->districtsEntryTranslationsModel = $districtsEntryTranslationsModel;
        $this->neighborhoodRepository = $neighborhoodRepository;
        $this->neighborhoodsEntryTranslationsModel = $neighborhoodsEntryTranslationsModel;
        $this->fieldRepository = $fieldRepository;
        $this->customFieldAdvRepository = $customFieldAdvRepository;
    }

    public function curl($url)
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://api.scraperapi.com/?api_key=' . $this->settingRepository->value('visiosoft.module.sahibinden::scraperapi_key') . '&url=' . $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $doc = new \DOMDocument;
            libxml_use_internal_errors(true);
            $doc->loadHTML($response);
            $xpath = new \DOMXPath($doc);
            return $xpath;
        }
    }

    public function getAdsLinks()
    {
        $paginationUrls = $this->scrapesController->getScrappedPages('pagination', 'sahibinden');

        $numLinks = array();
        foreach ($paginationUrls as $paginationUrl) {
            $adLinks = array();
            $xpath = $this->curl($paginationUrl['url']);
            $adsLinks = $xpath->query('//table/tbody/tr/td[1]/a');
            foreach ($adsLinks as $adLink) {
                $link = $adLink->getAttribute('href');
                if (!in_array($link, $adLinks)) {
                    $link = strpos($link, "http") === 0 ? $link : 'https://www.sahibinden.com' . $link;
                    $adLinks[] = $link;
                    $this->scrapesController->registerScrape($link, 'page', 'sahibinden');
                    $numLinks[] = $link;
                }
            }
            $paginationUrl->update([
                'processed' => 1
            ]);
        }

        echo count($numLinks);
    }

    function getAdDetails()
    {
        $pagesUrls = $this->scrapesController->getScrappedPages('page', 'sahibinden');

        foreach ($pagesUrls as $pageUrl) {
            $adDetails = array();

            $xpath = $this->curl($pageUrl->url);
            $adId = $xpath->query('//*[@id="classifiedId"]');
            $adId = $adId->item(0)->nodeValue;

            $username = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' username-info-area ')]/h5");
            $username = $username->item(0) ?
                $username->item(0)->nodeValue :
                $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' username-info-area ')]/p")->item(0)->nodeValue;

            $desc = $xpath->query('//*[@id="classifiedDescription"]');
            $desc = $desc->item(0)->nodeValue;

            $productName = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedDetailTitle ')]/h1");
            $productName = $productName->item(0)->nodeValue;

            $price = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedInfo ')]/h3/text()");
            $price = $price->item(0)->nodeValue;
            $price = array_filter(explode(' ', $price));
            unset($price[0]);
            sort($price);
            $price[0] = str_replace('.', '', $price[0]);

            $locations = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedInfo ')]/h2/a");
            $adLocation = array();
            foreach ($locations as $location) {
                $adLocation[] = preg_replace('/\s+/', '', $location->nodeValue);
            }

            $phone = $xpath->query('//*[@id="phoneInfoPart"]/li/span[1]');
            $phone = $phone->item($phone->length - 1) ? $phone->item($phone->length - 1)->nodeValue : 'No Phone Number';

            $categories = $xpath->query('//*[@id="uiBreadCrumb"]/li/a');

            $adCategory = array();
            foreach ($categories as $key => $category) {
                $adCategory[] = preg_replace('/\s+/', '', $category->nodeValue);
            }

            $images = array();
            $photos = $xpath->query("//div[contains(concat(' ', normalize-space(@class), ' '), ' classifiedDetailThumbListContainer ')]/ul/li/ul/li/label/img");
            foreach ($photos as $photo) {
                $newImage = array();
                $imagePath = $photo->getAttribute('src');
                $newImage['thmb'] = $imagePath;
                $newImage['org'] = substr($imagePath, 0, strpos($imagePath, "thmb")) . "x5" . substr($imagePath, strpos($imagePath, "thmb") + 4);
                $images[] = $newImage;
            }

            $customFields = array();
            $classifiedInfoListKeys  = $xpath->query("//ul[contains(concat(' ', normalize-space(@class), ' '), ' classifiedInfoList ')]/li/strong/text()");
            $classifiedInfoListValues = $xpath->query("//ul[contains(concat(' ', normalize-space(@class), ' '), ' classifiedInfoList ')]/li/span/text()");
            for ($i = 0; $i < count($classifiedInfoListKeys); $i++) {
                $fieldName = trim(preg_replace('/\s+/', ' ', $classifiedInfoListKeys->item($i)->data));
                $customFieldId = $this->fieldRepository->findBy('field_name', $fieldName);
                if (!is_null($customFieldId)) {
                    $customFields['cf' . $customFieldId->custom_field_id] = trim(preg_replace('/\s+/', ' ', $classifiedInfoListValues->item($i)->data));
                }
            }

            $adDetails['ad_id'] = $adId;
            $adDetails['cf_json'] = $customFields;
            $adDetails['price'] = $price;
            $adDetails['name'] = $productName;
            $adDetails['desc'] = $desc;
            $adDetails['city'] = $adLocation[0];
            if (count($adLocation) > 1) $adDetails['district'] = $adLocation[1];
            if (count($adLocation) > 2) $adDetails['neighborhood'] = $adLocation[2];
            $adDetails['phone'] = preg_replace("/[^0-9]/", "", $phone);
            $adDetails['images'] = $images;
            $adDetails['category'] = array_slice($adCategory, 0, count($adCategory) - 4);

            $user = $this->checkUser($username, $phone);
            $this->postAd($adDetails, $user);

            $pageUrl->update([
                'processed' => 1
            ]);
        }

        echo count($pagesUrls) . " ad(s) has been created!";
    }

    public function checkUser($username, $phoneNum)
    {
        $user = $this->userRepository->findBy('username', $this->str->slug($username, '_'));
        if (is_null($user)) {
            $user = $this->userRepository->create(
                [
                    'username' => $username,
                    'display_name' => $username,
                    'email' => $this->str->slug($username, "_") . '@user.com',
                    'activated' => 1,
                ]
            );
            $password = str_random(8);
            $user->setAttribute('password', $password);
            $this->userRepository->save($user);

            // Create a profile for the user
            $this->profileRepository->create([
                'user_no' => $user,
                'gsm_phone' => $phoneNum,
            ]);
        };

        return $user;
    }

    public function postAd($adDetails, $user)
    {
        /* Looping through the categories and creating an array of categories.. ['cat1', 'cat2', etc..] */
        $category = array();
        for ($i = 0; $i < count($adDetails['category']); $i++) {
            $catNumber = $i + 1;
            $cat = $this->categoryEntryTranslationsModel->newQuery()->where('name', $adDetails['category'][$i])->first();
            if (is_null($cat)) {
                if ($i !== 0) {
                    $parentCategory = $this->categoryEntryTranslationsModel->newQuery()->where('name', $adDetails['category'][$i - 1])->first();
                    $parentCategory = $this->categoryRepository->find($parentCategory->entry_id);
                } else {
                    $parentCategory = null;
                }
                $nameTranslation = array();
                foreach (config('streams::locales.enabled') as $locale) {
                    $nameTranslation[$locale] = [
                        'name' => $adDetails['category'][$i]
                    ];
                }
                $cat = $this->categoryRepository->create(array_merge($nameTranslation, [
                    'slug' => $this->str->slug($adDetails['category'][$i], '_'),
                    'parent_category' => $parentCategory,
                ]));
            } else {
                $cat = $this->categoryRepository->find($cat->entry_id);
            }

            $category['cat' . $catNumber] = $cat->id;
        }

        $city = $this->citiesEntryTranslationsModel->newQuery()->where('name', $adDetails['city'])->first();
        if (is_null($city)) {
            $city = $this->cityRepository->create([
                'name' => $adDetails['city'],
                'slug' => $this->str->slug($adDetails['city'], '_'),
                'parent_country_id' => $this->settingRepository->value('visiosoft.module.sahibinden::country_id'),
            ]);
        } else {
            $city = $this->cityRepository->find($city->entry_id);
        }

        $district = $this->districtsEntryTranslationsModel
            ->newQuery()
            ->where('name', $adDetails['district'])
            ->first();
        if (is_null($district)) {
            $district = $this->districtRepository->create([
                'name' => $adDetails['district'],
                'slug' => $this->str->slug($adDetails['district'], '_'),
                'parent_city_id' => $city->id,
            ]);
        } else {
            $district = $this->districtRepository->find($district->entry_id);
        }

        $neighborhood = $this->neighborhoodsEntryTranslationsModel
            ->newQuery()
            ->where('name', $adDetails['neighborhood'])
            ->first();
        if (is_null($neighborhood)) {
            $neighborhood = $this->neighborhoodRepository->create([
                'name' => $adDetails['neighborhood'],
                'slug' => $this->str->slug($adDetails['neighborhood'], '_'),
                'parent_district_id' => $district->id,
            ]);
        } else {
            $neighborhood = $this->neighborhoodRepository->find($neighborhood->entry_id);
        }

        $coverPhoto = reset($adDetails['images'])['org'];

        $date = date('Y-m-d H:i:s');
        $data = [
            'en' => [
                'name' => $adDetails['name'],
                'advs_desc' => $adDetails['desc'],
            ],
            'tr' => [
                'name' => $adDetails['name'],
                'advs_desc' => $adDetails['desc'],
            ],
            'price' => $adDetails['price'][0],
            'country_id' => $this->settingRepository->value('visiosoft.module.sahibinden::country_id'),
            'city' => $city->id,
            'district' => $district->id,
            'neighborhood' => $neighborhood->id,
            'slug' => $adDetails['name'] . '_' . $adDetails['ad_id'],
            'currency' => $adDetails['price'][1],
            'cover_photo' => $coverPhoto,
            'created_by_id' => $user->id,
            'status' => 'approved',
            'publish_at' => $date,
            'finish_at' => date('Y-m-d H:i:s', strtotime($date . ' + 60 day')),
        ];

        $adv = $this->advRepository->findBy('slug', $this->str->slug($adDetails['name'], '_') . '_' . $adDetails['ad_id']);
        if (is_null($adv)) {
            $adv = $this->advRepository->create(array_merge($data, $category));
            $this->savePhoto($adDetails['images'], $adv->id);
        } else {
            $adv->update(array_merge($data, $category));
        }

        $jsonCustomFields = $this->createCustomFields($adDetails['cf_json'], $adv);
        $adv->update([
            'cf_json' => $jsonCustomFields
        ]);
    }

    public function createCustomFields($customFields, $ad)
    {
        $jsonCustomFields = array();
        foreach ($customFields as $customFieldId => $customFieldValue) {
            $customField = $this->customFieldAdvRepository
                ->newQuery()
                ->where('parent_adv_id', $ad->id)
                ->where('custom_field_value', $customFieldValue)
                ->first();
            if (is_null($customField)) {
                $customField = $this->customFieldAdvRepository->create([
                    'parent_adv' => $ad,
                    'custom_field_category_id' => substr($customFieldId, 2),
                    'custom_field_value' => $customFieldValue
                ]);
            }
            $jsonCustomFields[$customFieldId] = $customField->id;
        }
        $jsonCustomFields = json_encode($jsonCustomFields, JSON_UNESCAPED_UNICODE);
        return $jsonCustomFields;
    }

    public function savePhoto($photosUrl, $advId)
    {
        /* Looping through the photo's URLs and saving them */
        foreach ($photosUrl as $photoUrl) {
            $link = $photoUrl['org'];
            $name = basename($link);
            $contents = file_get_contents($link);
            $target = getcwd() . "/app/default/files-module/local/images/" . $name;
            /* Saving the photos in the local storage */
            file_put_contents($target, $contents);
            $file = $this->saveFileInModel($name, $advId);
            DB::table('advs_advs_files')->insert(
                ['file_id' => $file->id, 'entry_id' => $advId]
            );
        }
    }

    public function saveFileInModel($filename, $advId)
    {
        return $this->postFiles->newQuery()->create(
            [
                'folder_id' => 1,
                'name' => $filename,
                'entry_id' => $advId,
                'disk_id' => 1,
                'size' => 1,
                'mime_type' => "image/jpeg",
                'extension' => 1,
            ]
        );
    }
}
