<?php namespace Visiosoft\S3AdapterExtension;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class S3AdapterExtensionSeeder extends Seeder
{
    public function run(
        FieldRepositoryInterface      $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        StreamRepositoryInterface     $streamRepository
    ){
        $namespace = 'files';
        $locked = 0;
        $stream = $streamRepository->findBySlugAndNamespace('files', 'files');

        $customFields = [
            [
                'name' => 'moved_s3',
                'slug' => 'moved_s3',
                'type' => 'anomaly.field_type.boolean',
                'config' => [
                    'default_value' => false,
                ]
            ],
        ];

        foreach ($customFields as $customField) {
            $field = $fieldRepository->findBySlugAndNamespace($customField['slug'], $namespace);

            if (!$field) {
                $data = [
                    'name' => $customField['name'],
                    'namespace' => $namespace,
                    'slug' => $customField['slug'],
                    'type' => $customField['type'],
                    'locked' => $locked
                ];
                if (isset($customField['config'])) {
                    $data['config'] = $customField['config'];
                }

                $field = $fieldRepository->create($data);
            }

            if (empty($assignmentRepository->findByStreamAndField($stream, $field))) {
                $assignmentRepository->create([
                    'stream_id' => $stream->id,
                    'field_id' => $field->id
                ]);
            }
        }
    }
}
