<?php namespace Visiosoft\S3AdapterExtension\Console;

use Anomaly\ConfigurationModule\Configuration\Contract\ConfigurationRepositoryInterface;
use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Illuminate\Console\Command;
use League\Flysystem\MountManager;
use Symfony\Component\Console\Input\InputArgument;

class FilesMove extends Command
{
    protected $name = 'disk:move';

    protected $description = 'You can use this command to move files from old disk to new disk.';

    protected $region = null;

    protected $key = null;

    protected $bucket = null;

    protected $secret = null;

    public function handle(DiskRepositoryInterface $disks,
                           FolderRepositoryInterface $folders,
                           FileRepositoryInterface $files,
                           MountManager $manager,
                           ConfigurationRepositoryInterface $configuration)
    {
        if (!$source_disk = $disks->findBySlug($this->argument('source_disk'))) {
            throw new \Exception("The disk [{$this->argument('source_disk')}] could not be found.");
        }

        if (!$to_disk = $disks->findBySlug($this->argument('to_disk'))) {
            throw new \Exception("The disk [{$this->argument('to_disk')}] could not be found.");
        }

        $this->info("[{$this->argument('source_disk')}] >>> [{$this->argument('to_disk')}] Started!");

        $this->region = $configuration->get('visiosoft.extension.s3_adapter::region', $to_disk->getSlug())->getValue();

        $this->key = $configuration->presenter('visiosoft.extension.s3_adapter::access_key', $to_disk->getSlug());

        $this->key = $this->key->decrypt();

        $this->secret = $configuration->presenter('visiosoft.extension.s3_adapter::secret_key', $to_disk->getSlug());

        $this->bucket = $configuration->get('visiosoft.extension.s3_adapter::bucket', $to_disk->getSlug())->getValue();

        $this->secret = $this->secret->decrypt();

        foreach ($folders->all() as $folder) {

            if ($folder->getDisk()->getSlug() == $to_disk->getSlug()) {
                continue;
            }

            $contents = array_filter(
                $manager->listContents($folder->path()),
                function (array $file) {
                    return $file['type'] == 'file';
                }
            );

            foreach ($contents as $file) {
                if ($file = $files->findByNameAndFolder($file['basename'], $folder) && !$file->moved_s3) {
                    $path = storage_path('streams/default/files-module/' . $source_disk->getSlug() . '/' . $file->path());

                    if (file_exists($path)) {
                        $this->createFile($path, $folder->getSlug() . '/' . $file->getName());

                        $file->setAttribute('moved_s3',true);
                        $file->save();

                        $this->info('Moved: ' . $folder->getSlug() . '/' . $file->getName());
                    } else {
                        $this->info("[{$file->getName()}] not found!");
                    }
                }
            }

            if ($folder->getDisk()->getSlug() != $to_disk->getSlug()) {
                $folder->setAttribute('disk_id', $to_disk->getId());
                $folder->save();
                $this->info("[{$folder->getSlug()}] disk updated!");
            }
        }

    }

    public function createFile($path, $filename)
    {
        $s3 = new \Aws\S3\S3Client([
            'region' => $this->region,
            'version' => 'latest',
            'credentials' => [
                'key' => $this->key,
                'secret' => $this->secret,
            ]
        ]);

        $result = $s3->putObject([
            'Bucket' => $this->bucket,
            'Key' => $filename,
            'SourceFile' => $path
        ]);
    }

    protected function getArguments()
    {
        return [
            ['to_disk', InputArgument::REQUIRED, 'Disk to be copied'],
            ['source_disk', InputArgument::REQUIRED, 'New disk slug'],
        ];
    }
}