
## Module Usage
use Visiosoft\RotaModule\Events\CustomerCreated;

use Visiosoft\RotaModule\Events\OrderCreated;

use Visiosoft\RotaModule\Events\ProductCreated;


#### Create New Card and Customer or Add card to Existing Customer

#### Create Customer

```http
$customer_params = [
    'customer_id' => 1,
    'name' => "Emrullah Ardıç",
    'phone' => "+905362533274",
    'tax_office' => "",
    'tax_number' => "",
    'identity_number' => "20335151550",
    'email' => "emrullahardc@gmail.com",
    'address' => "Yeni mh. Şehit Cezmi Mutlu Sk. No:2",
    'city' => "Kırklareli",
    'state' => "Lüleburgaz",
    'zipcode' => "34000",
    'country' => "Türkiye"
];

event(new CustomerCreated($customer_params));
```

#### Create Product

```http
$product_params = [
    'product_id' => 1,
    'name' => "Kingston 8GB USB Flash Drive",
    'barcode' => "KNG8GBUSB",
    'unit' => "adet",
    'description' => "Kingston 8GB 2.3 GHZ Write | 5.1 GHZ Read USB FLASH Drive",
];

event(new ProductCreated($product_params));
```

#### Create Invoice

```http
$invoice_params = [
    'customer_id' => 1,
    'order_id' => 1,
    'products' => [["id" => 1, "qty" => 1, "price" => 1, 'discount' => 0, 'total' => 1]],
    'subtotal' => 8.2,
    'discount' => 0,
    'tax' => 1.8,
    'total' => 10
];

event(new OrderCreated($invoice_params));
```
