<?php namespace Visiosoft\RotaModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\LocationModule\District\DistrictModel;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\OrdersModule\Orderpayment\Contract\OrderpaymentRepositoryInterface;
use Visiosoft\ProfileModule\Adress\Contract\AdressRepositoryInterface;
use Visiosoft\ProfileModule\Profile\ProfileModel;
use Visiosoft\RotaModule\Invoice\Contract\InvoiceRepositoryInterface;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;

class InvoiceController extends PublicController
{

    private $orderdetailRepository;
    private $orderpaymentRepository;
    private $advRepository;
    private $invoiceRepository;
    private $adressRepository;
    private $cityModel;
    private $districtModel;
    private $countryModel;
    private $profileModel;

    public function __construct(
        OrderdetailRepositoryInterface $orderdetailRepository,
        OrderpaymentRepositoryInterface $orderpaymentRepository,
        AdvRepositoryInterface $advRepository,
        InvoiceRepositoryInterface $invoiceRepository,
        AdressRepositoryInterface $adressRepository,
        CityModel $cityModel,
        DistrictModel $districtModel,
        CountryModel $countryModel,
        ProfileModel $profileModel
    )
    {
        parent::__construct();
        $this->orderdetailRepository = $orderdetailRepository;
        $this->orderpaymentRepository = $orderpaymentRepository;
        $this->advRepository = $advRepository;
        $this->invoiceRepository = $invoiceRepository;
        $this->adressRepository = $adressRepository;
        $this->cityModel = $cityModel;
        $this->districtModel = $districtModel;
        $this->countryModel = $countryModel;
        $this->profileModel = $profileModel;
    }

    public function handlePaymentOrder($user, $orderPaymentsId)
    {
        $requestData = $this->getRequestData($user, $orderPaymentsId);
        $response = $this->createRotaInvoiceAPI($requestData);
        if (isset($response['error']) && $response['error']) {
            $this->messages->error(trans('visiosoft.module.rota::message.create_invoice_error'));
        } else {
            $invoiceId = $this->createInvoice($response);

            $this->messages->success(trans('visiosoft.module.rota::message.create_invoice_success', [
                'id' => $invoiceId
            ]));
        }
    }

    public function getRequestData($user, $orderPaymentsId)
    {
        $requestData = array();

        $userProfile = $this->profileModel->where('user_no_id', $user->id)->first();
        $addressData = $this->getAddress($user->id);
        $orderpayment = $this->orderpaymentRepository->find($orderPaymentsId);
        $orderdetail = $this->orderdetailRepository->find($orderpayment->getAttribute("order-detail_id"));
        $adv = $this->advRepository->find($orderdetail->item_id);

        $date = date('Y-m-d H:i:s');
        $date = str_replace(" ","%20",$date);

        $requestData['email'] = $user->email;
        $requestData['itemcode'] = $orderdetail->item_id;
        $description = $adv->name;
        $requestData['description'] = urlencode($description);
        $requestData['qty'] = $orderdetail->piece;
        $requestData['amount'] = $orderdetail->total;
        $requestData['currency'] = setting_value('visiosoft.module.rota::currency');
        $requestData['vdairesi'] = setting_value('visiosoft.module.rota::vdairesi');
        $requestData['vkn'] = $userProfile->identification_number ? $userProfile->identification_number : setting_value('visiosoft.module.rota::vkn');
        $requestData['currency_value'] = setting_value('visiosoft.module.rota::currency_value');
        $requestData['api_key'] = setting_value('visiosoft.module.rota::api_key');
        $requestData['company_code'] = setting_value('visiosoft.module.rota::company_code');
        $requestData['company_name'] = setting_value('visiosoft.module.rota::company_name');
        $requestData['tax_rate'] = setting_value('visiosoft.module.rota::tax_rate');
        $requestData['tax'] = $requestData['amount'] * $requestData['tax_rate'] / 100;
        $requestData['discount'] = setting_value('visiosoft.module.rota::discount');
        $requestData['total'] = $requestData['amount'] - $requestData['discount'];
        $requestData['account'] = setting_value('visiosoft.module.rota::account');
        $requestData['date'] = $date;
        $requestData['address'] = $addressData['address'];
        $requestData['state'] = $addressData['state'];
        $requestData['city'] = $addressData['city'];
        $requestData['country'] = $addressData['country'];
        $requestData['nationality'] = $requestData['country'];
        $requestData['api_url'] = setting_value('visiosoft.module.rota::api_url');

        return $requestData;
    }

    public function createRotaInvoiceAPI($requestInfo)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $requestInfo['api_url'].'&api_key='.$requestInfo['api_key'].'&method=invoices&code='.$requestInfo['company_code'].'&name='.$requestInfo['company_name'].'&address='.$requestInfo['address'].'&state='.$requestInfo['state'].'&city='.$requestInfo['city'].'&country='.$requestInfo['country'].'&vkn='.$requestInfo['vkn'].'&vdairesi='.$requestInfo['vdairesi'].'&email='.$requestInfo['email'].'&nationality='.$requestInfo['nationality'].'&itemcode='.$requestInfo['itemcode'].'&description='.$requestInfo['description'].'&qty='.$requestInfo['qty'].'&unit=Piece&amount='.$requestInfo['amount'].'&tax='.$requestInfo['tax'].'&taxrate='.$requestInfo['tax_rate'].'&currency='.$requestInfo['currency'].'&currencyvalue='.$requestInfo['currency_value'].'&kdvdh=1&date='.$requestInfo['date'].'&duedate='.$requestInfo['date'].'&invdescription='.$requestInfo['description'].'&total='.$requestInfo['total'].'&discount='.$requestInfo['discount'].'&account='.$requestInfo['account'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            return ['error' => true];
//            dd("cURL Error #:" . $err);
        } else {
            if ($response) {
                return json_decode($response);
            } else {
                return ['error' => true];
            }
        }
    }

    public function createInvoice($response)
    {
        $invoice = $this->invoiceRepository->create([
            'invoice_id' => $response->id
        ]);
        return $invoice->id;
    }

    public function getAddress($userId)
    {
        $addressData = array();

        $address = $this->adressRepository->findBy('user_no_id', $userId);

        $addressData['address'] = $address->adress_name;
        $addressData['state'] = $this->cityModel->find($address->city)->name;
        $addressData['city'] = $this->districtModel->find($address->district)->name;
        $addressData['country'] = $this->countryModel->find($address->country_id)->name;

        foreach ($addressData as $index => $value) {
            $addressData[$index] = str_replace(" ","%20", $value);
        }

        return $addressData;
    }
}
