<?php namespace Visiosoft\RotaModule\V2\Job;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\CompanyModule\Company\Contract\CompanyInfoInterface;
use Visiosoft\RotaModule\Customer\Contract\CustomerRepositoryInterface;
use Visiosoft\RotaModule\RotaModule;

class CreateCompanyJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;

    private CompanyInfoInterface $companyInfo;

    public function __construct(CompanyInfoInterface $companyInfo)
    {
        $this->companyInfo = $companyInfo;
    }

    public function handle()
    {
        $rota = new RotaModule();

        $customerRepository = app(CustomerRepositoryInterface::class);
        $company = $rota->getCustomer($this->companyInfo->getTaxNumber());
        if (!$company) {
            $params = [
                'account' => $this->companyInfo->getName(),
                'code' => $this->companyInfo->getTaxNumber(),
                "phone" => $this->companyInfo->getContactPhone(),
                "gsmno" => $this->companyInfo->getContactPhone(),
                'vdairesi' => $this->companyInfo->getTaxOffice(),
                'vkn' => $this->companyInfo->getTaxNumber(),
                "tckn" => '',
                "email" => $this->companyInfo->getEmail(),
                'address' => $this->companyInfo->getAddress(),
                'city' => $this->companyInfo->getCity(),
                'state' => $this->companyInfo->getDistrict(),
                'country' => "TR",
                "gname" => setting_value('visiosoft.module.rota::default_non_identity_group_name', 'Şarj İstasyonu Kullanıcıları'),
                "gid" => setting_value('visiosoft.module.rota::default_non_identity_group_id', '2'),
                "firmaid" => setting_value('visiosoft.module.rota::company_id'),
                "subeid" => [["subeid" => setting_value('visiosoft.module.rota::branch_id')]],
                "user_id" => setting_value('visiosoft.module.rota::user_id')
            ];

            $create = $customerRepository->addToRota($params);
            if (!$create->message == "Chk was created.") {
                throw new \Exception($create->message);
            }
        }
    }

}