<?php namespace Visiosoft\RotaModule\Invoice\Listener;

use Visiosoft\RotaModule\Invoice\Contract\InvoiceRepositoryInterface;

class CreateInvoice
{
    public function __construct(InvoiceRepositoryInterface $invoiceRepository)
    {
        $this->invoiceRepository = $invoiceRepository;
    }

    public function handle(\Visiosoft\RotaModule\Events\OrderCreated $event)
    {
        $params = $event->getparams();
        $params['products'] = json_encode($params['products']);
        if (!$this->invoiceRepository->findBy('order_id', $params['order_id'])) {
            $this->invoiceRepository->create($params);
        }
    }
}


