<?php namespace Visiosoft\RotaModule\Command;

use Illuminate\Console\Command;
use Visiosoft\RotaModule\Receipt\Contract\ReceiptRepositoryInterface;
use Visiosoft\RotaModule\RotaModule;

class RotaCreateReceiptCommand extends Command
{
    protected $signature = 'rota:create_receipt';

    protected $description = 'create new receipt to rota';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        if (!setting_value('visiosoft.module.rota::create_receipt_schedule')) {
            return;
        }
        try {

            $rota = app(RotaModule::class);
            $receiptRepository = app(ReceiptRepositoryInterface::class);
            $pending_receipts = $receiptRepository->newQuery()->orderBy('id', 'asc')->where('sended', false)->get();
            foreach ($pending_receipts as $receipt) {
                $rota->createReceipt($receipt->toArray());
            }

        } catch (\Exception $e) {
            $this->error($e->getMessage());
        }
    }
}
