<?php namespace Visiosoft\RotaModule\V2\Job;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\PaymentModule\Payment\Contract\PaymentInterface;
use Visiosoft\RotaModule\RotaModule;

class CreateInvoiceJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    /**
     * @var mixed
     */
    private PaymentInterface $payment;


    public function __construct(PaymentInterface $payment)
    {
        $this->payment = $payment;
    }

    /**
     * @throws \Exception
     */
    public function handle()
    {
        $rota = new RotaModule();
        $rota->createInvoiceV2($this->payment);
    }

}