<?php namespace Visiosoft\RotaModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Rota\RotaCustomerEntryModel;
use Anomaly\Streams\Platform\Model\Rota\RotaInvoiceEntryModel;
use Anomaly\Streams\Platform\Model\Rota\RotaProductEntryModel;
use Anomaly\Streams\Platform\Model\Rota\RotaReceiptEntryModel;
use Visiosoft\CompanyModule\Event\CompanyCreatedEvent;
use Visiosoft\RotaModule\Command\RotaCreateReceiptCommand;
use Visiosoft\RotaModule\Customer\Contract\CustomerRepositoryInterface;
use Visiosoft\RotaModule\Customer\CustomerModel;
use Visiosoft\RotaModule\Customer\CustomerRepository;
use Visiosoft\RotaModule\Events\ReceiptCreated;
use Visiosoft\RotaModule\Invoice\Contract\InvoiceRepositoryInterface;
use Visiosoft\RotaModule\Invoice\InvoiceModel;
use Visiosoft\RotaModule\Invoice\InvoiceRepository;
use Visiosoft\RotaModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\RotaModule\Product\ProductModel;
use Visiosoft\RotaModule\Product\ProductRepository;
use Visiosoft\RotaModule\Receipt\Contract\ReceiptRepositoryInterface;
use Visiosoft\RotaModule\Receipt\ReceiptModel;
use Visiosoft\RotaModule\Receipt\ReceiptRepository;
use Visiosoft\RotaModule\V2\Listener\CompanyCreatedListener;

class RotaModuleServiceProvider extends AddonServiceProvider
{

    protected $commands = [
        RotaCreateReceiptCommand::class
    ];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        ReceiptCreated::class => [
            \Visiosoft\RotaModule\Receipt\Listener\CreateReceipt::class,
        ],
        CompanyCreatedEvent::class => [
            CompanyCreatedListener::class
        ]
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        RotaCustomerEntryModel::class => CustomerModel::class,
        RotaProductEntryModel::class => ProductModel::class,
        RotaInvoiceEntryModel::class => InvoiceModel::class,
        RotaReceiptEntryModel::class => ReceiptModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        CustomerRepositoryInterface::class => CustomerRepository::class,
        ProductRepositoryInterface::class => ProductRepository::class,
        InvoiceRepositoryInterface::class => InvoiceRepository::class,
        ReceiptRepositoryInterface::class => ReceiptRepository::class,
    ];
}
