<?php namespace Visiosoft\RotaModule\Receipt;

use Visiosoft\RotaModule\Helper\Helper;
use Visiosoft\RotaModule\Receipt\Contract\ReceiptRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ReceiptRepository extends EntryRepository implements ReceiptRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ReceiptModel
     */
    protected $model;
    protected $helper;

    /**
     * Create a new ReceiptRepository instance.
     *
     * @param ReceiptModel $model
     */
    public function __construct(ReceiptModel $model, Helper $helper)
    {
        $this->model = $model;
        $this->helper = $helper;
    }

    public function addToRota(array $params)
    {
        return $this->helper->request("POST", "/api/finance/addReceipt", [], json_encode($params));
    }
}
