<?php namespace Visiosoft\RotaModule\Command;

use Illuminate\Console\Command;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\RotaModule\Invoice\Contract\InvoiceRepositoryInterface;
use Visiosoft\RotaModule\RotaModule;

class RotaCreateInvoiceCommand extends Command
{
    protected $signature = 'rota:create_invoice';

    protected $description = 'create invoice to rota';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        if (!setting_value('visiosoft.module.rota::create_invoice_schedule')) {
            return;
        }
        $rota = app(RotaModule::class);
        $invoice = app(InvoiceRepositoryInterface::class);
        $pending_invoices = $invoice->findBy('sended', false, "get");

        foreach ($pending_invoices as $pending_invoice) {
            if (!empty($pending_invoice->user_id)) {
                $paymentInterface = app(PaymentRepositoryInterface::class)->find($pending_invoice->order_id);
                if ($paymentInterface) {
                    $rota->sendInvoice($paymentInterface);
                    $pending_invoice->delete();
                }
            } else {
                $rota->createInvoice($pending_invoice->toArray());
            }
        }
    }
}
