<?php namespace Visiosoft\RotaModule\Customer;

use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\RotaModule\Customer\Contract\CustomerRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\RotaModule\Helper\Helper;

class CustomerRepository extends EntryRepository implements CustomerRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CustomerModel
     */
    protected $model;

    /**
     * Create a new CustomerRepository instance.
     *
     * @param CustomerModel $model
     */

    protected $helper;

    public function __construct(CustomerModel $model, Helper $helper)
    {
        $this->model = $model;
        $this->helper = $helper;
    }

    public function findBy($type, $value, $list_type = "first")
    {
        return $this->model->newQuery()->where($type, $value)->$list_type();
    }

    public function listByRota(array $queryString)
    {
        return $this->helper->request("GET", "/api/chk/list", $queryString, []);
    }

    public function addToRota(array $params)
    {
        return $this->helper->request("POST", "/api/chk/add", [], json_encode($params));
    }

    public function updateByRota(array $params)
    {
        return $this->helper->request("PUT", "/api/chk/update", [], json_encode($params));
    }

    public function getTaxInformation(array $queryString): array
    {
        try {
            $response = $this->helper->request("GET", "/api/chk/turmob", $queryString, []);

            $response = json_decode(json_encode($response), true);

            if (strtolower($response['message']) !== 'success') {
                $log = new Logger('name');
                $log->pushHandler(new StreamHandler(storage_path('logs/rota.log')), Logger::INFO);
                $log->info($response['message']);

                return [];
            }

            $result = $response['result'][0];

            return [
                'company_name' => $result['unvan'],
                'street' => $result['cadde'],
                'city' => $result['ilce'],
                'company_detail' => json_encode($result)
            ];
        } catch (\Exception $exception) {
            $log = new Logger('name');
            $log->pushHandler(new StreamHandler(storage_path('logs/rota.log')), Logger::INFO);
            $log->info($exception->getMessage());

            return [];
        }
    }
}
