<?php namespace Visiosoft\RotaModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\OrdersModule\Orderdetail\Event\PaymentOrder;
use Visiosoft\RotaModule\Invoice\Contract\InvoiceRepositoryInterface;
use Visiosoft\RotaModule\Invoice\InvoiceRepository;
use Anomaly\Streams\Platform\Model\Rota\RotaInvoiceEntryModel;
use Visiosoft\RotaModule\Invoice\InvoiceModel;

class RotaModuleServiceProvider extends AddonServiceProvider
{
    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/rota'           => 'Visiosoft\RotaModule\Http\Controller\Admin\InvoiceController@index',
        'admin/rota/create'    => 'Visiosoft\RotaModule\Http\Controller\Admin\InvoiceController@create',
        'admin/rota/edit/{id}' => 'Visiosoft\RotaModule\Http\Controller\Admin\InvoiceController@edit',
    ];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        PaymentOrder::class => [
            \Visiosoft\RotaModule\Invoice\Listener\PaymentOrder::class,
        ],
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        RotaInvoiceEntryModel::class => InvoiceModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        InvoiceRepositoryInterface::class => InvoiceRepository::class,
    ];
}
