<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleRotaCreateProductStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'product',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */

    protected $fields = [
        'product_id' => "anomaly.field_type.text",
        'name' => "anomaly.field_type.text",
        'barcode' => "anomaly.field_type.text",
        'unit' => "anomaly.field_type.text",
        'description' => "anomaly.field_type.textarea"
    ];


    protected $assignments = [
        'product_id',
        'name',
        'barcode',
        'unit',
        'description',
        'rota_id',
        'sended',
        'sended_at'
    ];

}
